/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.temperature;

import dev.ftb.mods.ftbstuffnthings.crafting.NoInventory;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.JarRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.TemperatureSourceRecipe;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import dev.ftb.mods.ftbstuffnthings.temperature.Temperature;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public record TemperatureAndEfficiency(Temperature temperature, double efficiency) {
    public static final TemperatureAndEfficiency DEFAULT = new TemperatureAndEfficiency(Temperature.NORMAL, 1.0);

    public static TemperatureAndEfficiency fromLevel(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        for (RecipeHolder recipe : level.getRecipeManager().getRecipesFor(RecipesRegistry.TEMPERATURE_SOURCE_TYPE.get(), (RecipeInput)NoInventory.INSTANCE, level)) {
            if (!((TemperatureSourceRecipe)recipe.value()).test(state)) continue;
            return ((TemperatureSourceRecipe)recipe.value()).getTemperatureAndEfficiency();
        }
        return DEFAULT;
    }

    public int getRecipeTime(JarRecipe recipe) {
        return Mth.clamp((int)((int)((double)recipe.getTime() / this.efficiency)), (int)1, (int)Short.MAX_VALUE);
    }

    public Component formatEfficiency() {
        int eff = (int)(this.efficiency() * 100.0);
        ChatFormatting color = eff == 100 ? ChatFormatting.YELLOW : (eff > 100 ? ChatFormatting.GREEN : ChatFormatting.GOLD);
        return Component.literal((String)(eff + "%")).withStyle(color);
    }
}

