/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases;

import dev.ftb.mods.ftbteambases.config.ServerConfig;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.util.MiscUtil;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.event.PlayerJoinedPartyTeamEvent;
import dev.ftb.mods.ftbteams.api.event.PlayerLeftPartyTeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.food.FoodData;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class TeamEventListener {
    static void teamPlayerJoin(PlayerJoinedPartyTeamEvent event) {
        Team team = event.getTeam();
        ServerPlayer serverPlayer = event.getPlayer();
        if (!team.isPartyTeam() || team.getOwner() == serverPlayer.getUUID()) {
            return;
        }
        if (((Boolean)ServerConfig.CLEAR_PLAYER_INV_ON_JOIN.get()).booleanValue()) {
            MiscUtil.clearPlayerInventory(serverPlayer);
        }
        if (((Boolean)ServerConfig.HEAL_PLAYER_ON_JOIN.get()).booleanValue()) {
            serverPlayer.heal(serverPlayer.getMaxHealth());
            FoodData foodData = serverPlayer.getFoodData();
            foodData.setExhaustion(0.0f);
            foodData.setFoodLevel(20);
            foodData.setSaturation(5.0f);
        }
        BaseInstanceManager.get(serverPlayer.getServer()).teleportToBaseSpawn(serverPlayer, team.getTeamId());
    }

    static void teamPlayerLeftParty(PlayerLeftPartyTeamEvent event) {
        MinecraftServer server;
        MinecraftServer minecraftServer = server = event.getPlayer() == null ? ServerLifecycleHooks.getCurrentServer() : event.getPlayer().getServer();
        if (server != null) {
            BaseInstanceManager.get(server).onPlayerLeaveTeam(event.getPlayer(), event.getPlayerId());
        }
    }

    public static void teamDeleted(TeamEvent event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            BaseInstanceManager.get(server).deleteAndArchive(server, event.getTeam());
        }
    }
}

