/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.construction.workers;

import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.util.BooleanConsumer;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.data.construction.ConstructionWorker;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinition;
import dev.ftb.mods.ftbteambases.util.DynamicDimensionManager;
import dev.ftb.mods.ftbteambases.util.RegionCoords;
import dev.ftb.mods.ftbteambases.util.RegionExtents;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;

public abstract class AbstractStructureWorker
implements ConstructionWorker {
    protected final BaseDefinition baseDefinition;
    protected final boolean privateDimension;
    private final ResourceKey<Level> dimensionKey;
    protected BooleanConsumer onCompleted;
    private final RegionExtents extents;

    protected AbstractStructureWorker(ServerPlayer player, BaseDefinition baseDefinition, boolean privateDimension) {
        this.baseDefinition = baseDefinition;
        this.privateDimension = privateDimension;
        this.dimensionKey = privateDimension ? ConstructionWorker.makePrivateDimensionKeyFor(player.getGameProfile().getName().toLowerCase()) : ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)baseDefinition.dimensionSettings().dimensionId().orElse(FTBTeamBases.SHARED_DIMENSION_ID));
        MinecraftServer server = Objects.requireNonNull(player.getServer());
        RegionCoords startRegion = BaseInstanceManager.get(server).nextGenerationPos(server, baseDefinition, this.getDimension().location(), baseDefinition.extents());
        this.extents = new RegionExtents(startRegion, startRegion.offsetBy(baseDefinition.extents().x() - 1, baseDefinition.extents().z() - 1));
    }

    protected final ServerLevel getOrCreateLevel(MinecraftServer server) {
        return this.privateDimension ? DynamicDimensionManager.create(server, this.dimensionKey, this.baseDefinition) : server.getLevel(this.dimensionKey);
    }

    @Override
    public void startConstruction(BooleanConsumer onCompleted) {
        this.onCompleted = onCompleted;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimensionKey;
    }

    @Override
    public RegionExtents getRegionExtents() {
        return this.extents;
    }

    protected final BlockPos getPlacementOrigin(ServerLevel level, XZ xz, Optional<Integer> yPos) {
        int x = xz.x();
        int z = xz.z();
        return yPos.map(y -> new BlockPos(x, y.intValue(), z)).orElse(new BlockPos(x, level.getHeight(Heightmap.Types.WORLD_SURFACE, x, z), z));
    }
}

