/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.construction.workers;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftblibrary.util.BooleanConsumer;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.FTBTeamBasesException;
import dev.ftb.mods.ftbteambases.data.construction.workers.AbstractStructureWorker;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinition;
import dev.ftb.mods.ftbteambases.data.definition.SingleStructure;
import dev.ftb.mods.ftbteambases.util.DimensionUtils;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SingleStructureWorker
extends AbstractStructureWorker {
    private final ServerPlayer player;
    private final SingleStructure singleStructure;

    public SingleStructureWorker(ServerPlayer player, BaseDefinition baseDefinition, SingleStructure singleStructure, boolean privateDimension) {
        super(player, baseDefinition, privateDimension);
        this.player = player;
        this.singleStructure = singleStructure;
    }

    @Override
    public void startConstruction(BooleanConsumer onCompleted) {
        super.startConstruction(onCompleted);
        ServerLevel serverLevel = this.getOrCreateLevel(this.player.getServer());
        StructureTemplate template = serverLevel.getStructureManager().getOrCreate(this.singleStructure.structureLocation());
        StructurePlaceSettings placeSettings = DimensionUtils.makePlacementSettings(template, this.singleStructure.includeEntities());
        BlockPos origin = this.getPlacementOrigin(serverLevel, this.getSpawnXZ(), this.singleStructure.yPos());
        BlockPos templatePos = origin.offset(-(template.getSize().getX() / 2), 0, -(template.getSize().getZ() / 2));
        ChunkPos cp = new ChunkPos(templatePos);
        if (serverLevel.getChunkSource().getChunk(cp.x, cp.z, ChunkStatus.FULL, true) == null) {
            throw new FTBTeamBasesException("Single Structure Worker: can't load chunk at " + String.valueOf(this.getDimension().location()) + " / " + String.valueOf(cp));
        }
        template.placeInWorld((ServerLevelAccessor)serverLevel, templatePos, templatePos, placeSettings, serverLevel.random, 3);
        this.postProcess(template, templatePos, placeSettings, serverLevel);
    }

    private void postProcess(StructureTemplate template, BlockPos origin, StructurePlaceSettings placeSettings, ServerLevel serverLevel) {
        for (StructureTemplate.StructureBlockInfo info : template.filterBlocks(BlockPos.ZERO, placeSettings, Blocks.STRUCTURE_BLOCK)) {
            serverLevel.setBlock(info.pos().offset((Vec3i)origin), Blocks.AIR.defaultBlockState(), 3);
        }
        for (StructureTemplate.StructureBlockInfo info : template.filterBlocks(BlockPos.ZERO, placeSettings, Blocks.JIGSAW)) {
            if (info.nbt() == null) continue;
            String stateName = info.nbt().getString("final_state");
            try {
                BlockState state = BlockStateParser.parseForBlock((HolderLookup)serverLevel.holderLookup(Registries.BLOCK), (String)stateName, (boolean)true).blockState();
                serverLevel.setBlock(info.pos().offset((Vec3i)origin), state, 3);
            }
            catch (CommandSyntaxException e) {
                FTBTeamBases.LOGGER.error("Error while parsing blockstate {} in jigsaw block @ {} : {}", (Object)stateName, (Object)info.pos(), (Object)e.getMessage());
                serverLevel.setBlock(info.pos(), Blocks.AIR.defaultBlockState(), 3);
            }
        }
    }

    @Override
    public void tick() {
        this.onCompleted.accept(true);
    }
}

