/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.definition;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.FTBTeamBasesException;
import dev.ftb.mods.ftbteambases.config.ClientConfig;
import dev.ftb.mods.ftbteambases.data.construction.ConstructionWorker;
import dev.ftb.mods.ftbteambases.data.construction.workers.JigsawWorker;
import dev.ftb.mods.ftbteambases.data.construction.workers.PrivateDimensionPregenWorker;
import dev.ftb.mods.ftbteambases.data.construction.workers.RelocatingPregenWorker;
import dev.ftb.mods.ftbteambases.data.construction.workers.SingleStructureWorker;
import dev.ftb.mods.ftbteambases.data.definition.ConstructionType;
import dev.ftb.mods.ftbteambases.data.definition.DimensionSettings;
import dev.ftb.mods.ftbteambases.data.definition.DisplaySettings;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.loading.FMLLoader;

public record BaseDefinition(ResourceLocation id, DisplaySettings displaySettings, BlockPos spawnOffset, DimensionSettings dimensionSettings, ConstructionType constructionType, XZ extents) {
    public static final ResourceLocation DEFAULT_PREVIEW = FTBTeamBases.rl("default");
    public static final ResourceLocation FALLBACK_IMAGE = FTBTeamBases.rl("textures/fallback.png");
    public static final ResourceLocation DEFAULT_DIMENSION_TYPE = FTBTeamBases.rl("default");
    public static final ResourceLocation DEFAULT_STRUCTURE_SET = FTBTeamBases.rl("default");
    public static final Codec<BaseDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(BaseDefinition::id), (App)DisplaySettings.CODEC.fieldOf("display").forGetter(BaseDefinition::displaySettings), (App)BlockPos.CODEC.optionalFieldOf("spawn_offset", (Object)BlockPos.ZERO).forGetter(BaseDefinition::spawnOffset), (App)DimensionSettings.CODEC.fieldOf("dimension").forGetter(BaseDefinition::dimensionSettings), (App)ConstructionType.CODEC.fieldOf("construction").forGetter(BaseDefinition::constructionType), (App)XZ.CODEC.optionalFieldOf("extents", (Object)XZ.of((int)1, (int)1)).forGetter(BaseDefinition::extents)).apply((Applicative)instance, BaseDefinition::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BaseDefinition> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, BaseDefinition::id, DisplaySettings.STREAM_CODEC, BaseDefinition::displaySettings, (StreamCodec)BlockPos.STREAM_CODEC, BaseDefinition::spawnOffset, DimensionSettings.STREAM_CODEC, BaseDefinition::dimensionSettings, ConstructionType.STREAM_CODEC, BaseDefinition::constructionType, (StreamCodec)XZ.STREAM_CODEC, BaseDefinition::extents, BaseDefinition::new);

    public static Optional<BaseDefinition> fromJson(JsonElement element) {
        return CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial(error -> FTBTeamBases.LOGGER.error("JSON parse failure: {}", error)).map(Pair::getFirst);
    }

    public ConstructionWorker createConstructionWorker(ServerPlayer player) throws IOException {
        if (this.constructionType.pregen().isPresent()) {
            if (this.dimensionSettings.privateDimension()) {
                return new PrivateDimensionPregenWorker(player, this, this.constructionType.pregen().get());
            }
            return new RelocatingPregenWorker(player, this, this.constructionType.pregen().get());
        }
        if (this.constructionType.jigsaw().isPresent()) {
            return new JigsawWorker(player, this, this.constructionType.jigsaw().get(), this.dimensionSettings.privateDimension());
        }
        if (this.constructionType.singleStructure().isPresent()) {
            return new SingleStructureWorker(player, this, this.constructionType.singleStructure().get(), this.dimensionSettings.privateDimension());
        }
        throw new FTBTeamBasesException("base definition type not supported yet! " + String.valueOf(this.id));
    }

    public boolean matchesName(String filterStr) {
        return this.displaySettings.descriptionMatches(filterStr);
    }

    public boolean shouldShowInGui() {
        return !this.displaySettings.devMode() || !FMLLoader.isProduction() || (Boolean)ClientConfig.SHOW_DEV_BASES.get() != false;
    }

    public int displayOrder() {
        return this.displaySettings.displayOrder();
    }

    public String description() {
        return this.displaySettings().description();
    }

    public String author() {
        return this.displaySettings().author();
    }

    public ResourceLocation previewImage() {
        return this.displaySettings().previewImage().orElse(DEFAULT_PREVIEW);
    }
}

