/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.net;

import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record VisitBaseMessage(String teamName, boolean archived) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<VisitBaseMessage> TYPE = new CustomPacketPayload.Type(FTBTeamBases.rl("visit_base"));
    public static final StreamCodec<FriendlyByteBuf, VisitBaseMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, VisitBaseMessage::teamName, (StreamCodec)ByteBufCodecs.BOOL, VisitBaseMessage::archived, VisitBaseMessage::new);

    public static void handle(VisitBaseMessage message, IPayloadContext context) {
        ServerPlayer sp;
        Player player = context.player();
        if (player instanceof ServerPlayer && (sp = (ServerPlayer)player).hasPermissions(2) && sp.getServer() != null) {
            if (message.archived) {
                BaseInstanceManager.get(sp.getServer()).teleportToArchivedBase(sp, message.teamName);
            } else {
                FTBTeamsAPI.api().getManager().getTeamByName(message.teamName).ifPresent(team -> BaseInstanceManager.get(sp.getServer()).teleportToBaseSpawn(sp, team.getTeamId()));
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

