/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.util;

import com.google.common.math.Stats;
import dev.ftb.mods.ftbteambases.integration.CuriosIntegration;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.neoforged.fml.ModList;

public class MiscUtil {
    public static String blockPosStr(BlockPos pos) {
        return String.format("[%d,%d,%d]", pos.getX(), pos.getY(), pos.getZ());
    }

    public static void setOverworldTime(MinecraftServer server, long newTime) {
        ServerLevel overworld = server.getLevel(Level.OVERWORLD);
        if (overworld != null) {
            LevelData levelData;
            overworld.setDayTime(newTime);
            if (overworld.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE) && overworld.isRaining() && (levelData = overworld.getLevelData()) instanceof ServerLevelData) {
                ServerLevelData data = (ServerLevelData)levelData;
                data.setRainTime(0);
                data.setRaining(false);
                data.setThunderTime(0);
                data.setThundering(false);
            }
        }
    }

    public static double getTickTime(MinecraftServer server, ResourceKey<Level> key) {
        long[] times = server.getTickTime(key);
        if (times == null) {
            times = new long[]{0L};
        }
        return Stats.meanOf((long[])times) * 1.0E-6;
    }

    public static void clearPlayerInventory(ServerPlayer serverPlayer) {
        serverPlayer.getInventory().clearOrCountMatchingItems(arg -> true, -1, (Container)serverPlayer.inventoryMenu.getCraftSlots());
        serverPlayer.containerMenu.broadcastChanges();
        serverPlayer.inventoryMenu.slotsChanged((Container)serverPlayer.getInventory());
        if (ModList.get().isLoaded("curios")) {
            CuriosIntegration.clearCurios(serverPlayer);
        }
    }
}

