/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.crafting.recipe;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbunearthed.crafting.ItemWithChance;
import dev.ftb.mods.ftbunearthed.crafting.recipe.BaseRecipe;
import dev.ftb.mods.ftbunearthed.item.WorkerToken;
import dev.ftb.mods.ftbunearthed.registry.ModDataComponents;
import dev.ftb.mods.ftbunearthed.registry.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;

public class UneartherRecipe
extends BaseRecipe<UneartherRecipe>
implements Comparable<UneartherRecipe> {
    private final WorkerToken.WorkerData workerData;
    private final Ingredient toolItem;
    private final String inputStateStr;
    private final Lazy<BlockPredicateArgument.Result> inputPredicate;
    private final int processingTime;
    private final List<ItemWithChance> outputs;
    private final float damageChance;

    public UneartherRecipe(String inputStateStr, WorkerToken.WorkerData workerData, Ingredient toolItem, int processingTime, List<ItemWithChance> outputs, float damageChance) {
        super(ModRecipes.UNEARTHER_SERIALIZER, ModRecipes.UNEARTHER_TYPE);
        this.inputStateStr = inputStateStr;
        this.workerData = workerData;
        this.toolItem = toolItem;
        this.processingTime = processingTime;
        this.outputs = outputs;
        this.damageChance = damageChance;
        this.inputPredicate = Lazy.of(() -> {
            try {
                return BlockPredicateArgument.parse((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (StringReader)new StringReader(inputStateStr));
            }
            catch (CommandSyntaxException e) {
                return new BadResult();
            }
        });
    }

    public String getInputStateStr() {
        return this.inputStateStr;
    }

    private Set<Block> getInputBlocks() {
        Object object = this.inputPredicate.get();
        if (object instanceof BlockPredicateArgument.BlockPredicate) {
            BlockPredicateArgument.BlockPredicate b = (BlockPredicateArgument.BlockPredicate)object;
            return Set.of(b.state.getBlock());
        }
        object = this.inputPredicate.get();
        if (object instanceof BlockPredicateArgument.TagPredicate) {
            BlockPredicateArgument.TagPredicate t = (BlockPredicateArgument.TagPredicate)object;
            return t.tag.stream().map(Holder::value).collect(Collectors.toSet());
        }
        return Set.of();
    }

    public List<Either<ItemStack, Fluid>> getInputsForDisplay() {
        Set<Block> blocks = this.getInputBlocks();
        ArrayList<Either<ItemStack, Fluid>> res = new ArrayList<Either<ItemStack, Fluid>>();
        for (Block b : blocks) {
            if (b instanceof LiquidBlock) {
                LiquidBlock l = (LiquidBlock)b;
                if (l.fluid == Fluids.EMPTY) continue;
                res.add((Either<ItemStack, Fluid>)Either.right((Object)l.fluid));
                continue;
            }
            ItemStack s = b.asItem().getDefaultInstance();
            if (s.isEmpty()) continue;
            res.add((Either<ItemStack, Fluid>)Either.left((Object)s));
        }
        return res;
    }

    public WorkerToken.WorkerData getWorkerData() {
        return this.workerData;
    }

    public Ingredient getToolItem() {
        return this.toolItem;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public List<ItemWithChance> getOutputs() {
        return this.outputs;
    }

    public float getDamageChance() {
        return this.damageChance;
    }

    public boolean test(ItemStack inputStack, ItemStack workerStack, ItemStack toolStack) {
        return this.isValidInput(inputStack) && this.workerData.test(workerStack, toolStack.has(ModDataComponents.SUPER_BRUSH)) && this.toolItem.test(toolStack);
    }

    public boolean testManual(ItemStack inputStack, int playerUneartherLevel, ItemStack toolStack) {
        return this.isValidInput(inputStack) && this.toolItem.test(toolStack) && playerUneartherLevel >= this.workerData.getVillagerLevel();
    }

    public List<ItemStack> generateOutputs(RandomSource rand) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        this.outputs.forEach(o -> o.tryProduce(rand, results::add));
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidInput(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) return false;
        BlockItem bi = (BlockItem)item;
        if (!this.getInputBlocks().contains(bi.getBlock())) return false;
        return true;
    }

    @Override
    public int compareTo(@NotNull UneartherRecipe o) {
        return Integer.compare(this.workerData.getVillagerLevel(), o.workerData.getVillagerLevel());
    }

    private static class BadResult
    implements BlockPredicateArgument.Result {
        private BadResult() {
        }

        public boolean test(BlockInWorld blockInWorld) {
            return false;
        }

        public boolean requiresNbt() {
            return false;
        }
    }

    public static class Serializer<T extends UneartherRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("input_block").forGetter(UneartherRecipe::getInputStateStr), (App)WorkerToken.WorkerData.COMPONENT_CODEC.fieldOf("worker").forGetter(UneartherRecipe::getWorkerData), (App)Ingredient.CODEC_NONEMPTY.fieldOf("tool_item").forGetter(UneartherRecipe::getToolItem), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("processing_time", (Object)200).forGetter(UneartherRecipe::getProcessingTime), (App)ItemWithChance.CODEC.listOf().fieldOf("output_items").forGetter(UneartherRecipe::getOutputs), (App)Codec.FLOAT.validate(this::zeroToOne).optionalFieldOf("damage_chance", (Object)Float.valueOf(1.0f)).forGetter(UneartherRecipe::getDamageChance)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, UneartherRecipe::getInputStateStr, WorkerToken.WorkerData.STREAM_CODEC, UneartherRecipe::getWorkerData, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, UneartherRecipe::getToolItem, (StreamCodec)ByteBufCodecs.VAR_INT, UneartherRecipe::getProcessingTime, (StreamCodec)ItemWithChance.STREAM_CODEC.apply(ByteBufCodecs.list()), UneartherRecipe::getOutputs, (StreamCodec)ByteBufCodecs.FLOAT, UneartherRecipe::getDamageChance, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        private DataResult<Float> zeroToOne(float f) {
            return f >= 0.0f && f <= 1.0f ? DataResult.success((Object)Float.valueOf(f)) : DataResult.error(() -> "must be in range 0 to 1 (got " + f + ")");
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends UneartherRecipe> {
        public T create(String var1, WorkerToken.WorkerData var2, Ingredient var3, int var4, List<ItemWithChance> var5, float var6);
    }
}

