/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.integration.jei;

import dev.ftb.mods.ftbunearthed.FTBUnearthed;
import dev.ftb.mods.ftbunearthed.client.UneartherScreen;
import dev.ftb.mods.ftbunearthed.crafting.IHideableRecipe;
import dev.ftb.mods.ftbunearthed.integration.jei.RecipeTypes;
import dev.ftb.mods.ftbunearthed.integration.jei.UneartherCategory;
import dev.ftb.mods.ftbunearthed.item.WorkerToken;
import dev.ftb.mods.ftbunearthed.registry.ModBlocks;
import dev.ftb.mods.ftbunearthed.registry.ModItems;
import dev.ftb.mods.ftbunearthed.registry.ModRecipes;
import java.util.List;
import java.util.SequencedCollection;
import java.util.function.Function;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class UnearthedJeiPlugin
implements IModPlugin {
    static IJeiHelpers jeiHelpers;
    private static final ResourceLocation ID;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        jeiHelpers = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new UneartherCategory()});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.addRecipeType(registration, ModRecipes.UNEARTHER_TYPE.get(), RecipeTypes.UNEARTHER);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(ModBlocks.CORE.toStack(), new RecipeType[]{RecipeTypes.UNEARTHER});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.WORKER_TOKEN.get(), (ISubtypeInterpreter)new ISubtypeInterpreter<ItemStack>(this){

            @Nullable
            public Object getSubtypeData(ItemStack ingredient, UidContext context) {
                WorkerToken.WorkerData data = WorkerToken.getWorkerData(ingredient);
                return context == UidContext.Ingredient ? new ProfessionAndLevel(data.profession(), data.getVillagerLevel()) : data.profession();
            }

            public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
                return "";
            }
        });
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(UneartherScreen.class, 87, 17, 21, 18, new RecipeType[]{RecipeTypes.UNEARTHER});
    }

    private <I extends RecipeInput, T extends Recipe<I>> void addRecipeType(IRecipeRegistration registration, net.minecraft.world.item.crafting.RecipeType<T> mcRecipeType, RecipeType<T> jeiRecipeType) {
        this.addRecipeType(registration, mcRecipeType, jeiRecipeType, Function.identity());
    }

    private <I extends RecipeInput, T extends Recipe<I>> void addRecipeType(IRecipeRegistration registration, net.minecraft.world.item.crafting.RecipeType<T> mcRecipeType, RecipeType<T> jeiRecipeType, Function<List<T>, List<T>> postProcessor) {
        List<Recipe> recipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(mcRecipeType).stream().map(RecipeHolder::value).sorted().filter(IHideableRecipe::shouldShow).toList();
        registration.addRecipes(jeiRecipeType, postProcessor.apply((List<SequencedCollection>)recipes.reversed()));
    }

    static {
        ID = FTBUnearthed.id("default");
    }

    public record ProfessionAndLevel(VillagerProfession profession, int level) {
    }
}

