/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.entity;

import dev.ftb.mods.ftboceanmobs.entity.BaseRiftMob;
import dev.ftb.mods.ftboceanmobs.registry.ModParticleTypes;
import dev.ftb.mods.ftboceanmobs.registry.ModSounds;
import dev.ftb.mods.ftboceanmobs.util.MiscUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MossbackGoliath
extends BaseRiftMob {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int nextShardTick;
    private int shardWarmupTicks;
    private int firingCooldown;
    protected static final EntityDataAccessor<Boolean> DATA_SHARD_WARMUP = SynchedEntityData.defineId(MossbackGoliath.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> DATA_SHARD_FIRING = SynchedEntityData.defineId(MossbackGoliath.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_ATTACK_TARGET = SynchedEntityData.defineId(MossbackGoliath.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private LivingEntity clientSideCachedAttackTarget;

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.28f).add(Attributes.MAX_HEALTH, 50.0).add(Attributes.ARMOR, 8.0).add(Attributes.ARMOR_TOUGHNESS, 6.0).add(Attributes.FOLLOW_RANGE, 36.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 0.3333333432674408).add(Attributes.ATTACK_DAMAGE, 0.0);
    }

    public MossbackGoliath(EntityType<? extends MossbackGoliath> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SHARD_WARMUP, (Object)false);
        builder.define(DATA_SHARD_FIRING, (Object)false);
        builder.define(DATA_ATTACK_TARGET, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ShardAttackGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.3, 32.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkIdleController((GeoAnimatable)this));
        controllers.add(new AnimationController((GeoAnimatable)this, "Attacking", 5, this::attackState));
    }

    private PlayState attackState(AnimationState<MossbackGoliath> state) {
        return (Boolean)this.getEntityData().get(DATA_SHARD_WARMUP) != false ? state.setAndContinue(DefaultAnimations.ATTACK_SHOOT) : PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int getCurrentSwingDuration() {
        return 35;
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide() && ((Boolean)this.entityData.get(DATA_SHARD_FIRING)).booleanValue() && --this.firingCooldown <= 0) {
            this.entityData.set(DATA_SHARD_FIRING, (Object)false);
        }
    }

    public boolean hasSyncedTarget() {
        return (Integer)this.entityData.get(DATA_ATTACK_TARGET) != 0;
    }

    public void setSyncedTarget(@Nullable LivingEntity target) {
        this.entityData.set(DATA_ATTACK_TARGET, (Object)(target == null ? 0 : target.getId()));
    }

    @Nullable
    public LivingEntity getSyncedTarget() {
        if (!this.hasSyncedTarget()) {
            return null;
        }
        if (this.level().isClientSide) {
            if (this.clientSideCachedAttackTarget != null) {
                return this.clientSideCachedAttackTarget;
            }
            Entity entity = this.level().getEntity(((Integer)this.entityData.get(DATA_ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                this.clientSideCachedAttackTarget = (LivingEntity)entity;
                return this.clientSideCachedAttackTarget;
            }
            return null;
        }
        return this.getTarget();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (this.level().isClientSide) {
            if (DATA_SHARD_FIRING.equals(key) && ((Boolean)this.entityData.get(DATA_SHARD_FIRING)).booleanValue() && this.getSyncedTarget() != null) {
                MiscUtil.doParticleSpray((LivingEntity)this, this.getSyncedTarget(), (ParticleOptions)ModParticleTypes.MOSSBACK_SHARD.get(), 15);
            } else if (DATA_ATTACK_TARGET.equals(key)) {
                this.clientSideCachedAttackTarget = null;
            }
        }
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.MOSSBACK_GOLIATH_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.AMETHYST_BLOCK_STEP);
    }

    private static class ShardAttackGoal
    extends Goal {
        private static final int SHARD_WARMUP_TICKS = 35;
        private final MossbackGoliath mossback;

        public ShardAttackGoal(MossbackGoliath mossback) {
            this.mossback = mossback;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity target = this.mossback.getTarget();
            return target != null && target.isAlive() && this.mossback.canAttack(target) && this.mossback.tickCount >= this.mossback.nextShardTick && this.mossback.distanceToSqr((Entity)target) < 400.0 && this.mossback.getSensing().hasLineOfSight((Entity)target);
        }

        public boolean canContinueToUse() {
            LivingEntity target = this.mossback.getTarget();
            return this.mossback.shardWarmupTicks > 0 && target != null && target.isAlive() && this.mossback.canAttack(target);
        }

        public void stop() {
            this.mossback.getEntityData().set(DATA_SHARD_WARMUP, (Object)false);
            this.mossback.setSyncedTarget(null);
        }

        public void start() {
            this.mossback.getEntityData().set(DATA_SHARD_WARMUP, (Object)true);
            this.mossback.shardWarmupTicks = this.adjustedTickDelay(35);
            this.mossback.nextShardTick = this.mossback.tickCount + this.mossback.level().random.nextInt(80) + 20 + 35;
            if (this.mossback.getTarget() != null) {
                this.mossback.getNavigation().stop();
                this.mossback.getLookControl().setLookAt((Entity)this.mossback.getTarget(), 180.0f, 180.0f);
            }
            this.mossback.setSyncedTarget(this.mossback.getTarget());
        }

        public void tick() {
            Level level;
            LivingEntity target = this.mossback.getTarget();
            if (target != null && (level = this.mossback.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.mossback.getSensing().hasLineOfSight((Entity)target)) {
                    this.mossback.lookControl.setLookAt((Entity)target, 45.0f, 45.0f);
                    --this.mossback.shardWarmupTicks;
                    if (this.mossback.shardWarmupTicks == 8) {
                        this.mossback.entityData.set(DATA_SHARD_FIRING, (Object)true);
                        this.mossback.firingCooldown = 4;
                        this.mossback.playSound(SoundEvents.WITCH_THROW, 1.0f, 1.0f);
                    } else if (this.mossback.shardWarmupTicks == 0) {
                        if (target.isBlocking() && target.getItemBySlot(EquipmentSlot.OFFHAND).getItem() instanceof ShieldItem) {
                            target.level().playSound(null, target.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.HOSTILE, 1.0f, 1.0f);
                            target.getOffhandItem().hurtAndBreak(1, target, EquipmentSlot.OFFHAND);
                        } else {
                            target.hurt(serverLevel.damageSources().mobAttack((LivingEntity)this.mossback), 3.0f);
                            target.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 50 + this.mossback.getRandom().nextInt(40)));
                        }
                    }
                }
            }
        }
    }
}

