/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.integration.emi;

import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.List;
import java.util.Random;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.integration.emi.GAGEmiPlugin;
import ky.someone.mods.gag.item.data.Pigment;
import ky.someone.mods.gag.recipe.pigment.PigmentJarSplittingRecipe;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;

public class EmiPigmentJarSplittingRecipe
extends EmiPatternCraftingRecipe {
    private static final List<DyeColor> DYES = List.of(DyeColor.values());

    public EmiPigmentJarSplittingRecipe() {
        super(List.of(EmiStack.of(GAGRegistry.PIGMENT_JAR).setRemainder(EmiStack.of(GAGRegistry.PIGMENT_JAR))), EmiStack.of(GAGRegistry.PIGMENT_JAR), GAGEmiPlugin.synthetic(PigmentJarSplittingRecipe.ID));
    }

    public SlotWidget getInputWidget(int slot, int x, int y) {
        return new GeneratedSlotWidget(r -> {
            Pigment pigment = this.randomPigment((Random)r);
            int amount = pigment.amount();
            if (slot == 0) {
                return EmiStack.of((ItemStack)pigment.asJar());
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(this::getJarForRecipe, this.unique, x, y);
    }

    private EmiStack getJarForRecipe(Random random) {
        Pigment pigment = this.randomPigment(random);
        int amount = pigment.amount() / 2;
        return EmiStack.of((ItemStack)pigment.withAmount(amount).asJar()).setAmount(2L);
    }

    private Pigment randomPigment(Random random) {
        int color = random.nextInt(0x2000000);
        int amount = random.nextInt(16) * 2 + 4;
        return Pigment.ofRgb(color, amount);
    }
}

