/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import java.util.List;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.config.GAGClientConfig;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.item.HearthstoneItem;
import ky.someone.mods.gag.item.data.TeleportPos;
import ky.someone.mods.gag.util.GAGUtil;
import ky.someone.mods.gag.util.Tooltips;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EnergizedHearthstoneItem
extends HearthstoneItem {
    public EnergizedHearthstoneItem() {
        super(new Item.Properties().durability(GAGConfig.hearthstone.energizedDurability()));
    }

    public boolean isBound(ItemStack stack) {
        return stack.has(GAGRegistry.TELEPORT_TARGET_DATA);
    }

    @Override
    public TeleportPos getTeleportPos(@Nullable Player player, ItemStack stack) {
        return (TeleportPos)stack.get(GAGRegistry.TELEPORT_TARGET_DATA);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(this.getTargetText(null, stack));
        GAGUtil.appendInfoTooltip(tooltip, List.of(this.getTranslation(Tooltips.MAIN, "info_adv", new Object[0]), Tooltips.EXTRA.lang("info.gag.supports_unbreaking", new Object[0])));
    }

    @Override
    public Component getTargetText(@Nullable Player player, ItemStack stack) {
        TeleportPos target = this.getTeleportPos(player, stack);
        if (target != null) {
            if (GAGClientConfig.hearthstoneHidePosition || stack.has(GAGRegistry.HIDE_TARGET_DATA)) {
                return this.getTranslation(Tooltips.INFO, "target.bound", this.getTranslation(Tooltips.FLAVOUR, "target.hidden", new Object[0]));
            }
            if (player == null || !target.level().equals((Object)player.level().dimension())) {
                return this.getTranslation(Tooltips.INFO, "target.bound", target.formatFull());
            }
            return this.getTranslation(Tooltips.INFO, "target.bound", target.formatPos());
        }
        return this.getTranslation(Tooltips.FAIL, "target.unbound", new Object[0]);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!this.isBound(stack)) {
            if (player.isShiftKeyDown()) {
                TeleportPos pos = new TeleportPos((ResourceKey<Level>)player.level().dimension(), player.position(), player.getYRot());
                stack.set(GAGRegistry.TELEPORT_TARGET_DATA, (Object)pos);
                player.playSound((SoundEvent)GAGRegistry.HEARTHSTONE_THUNDER.value(), 0.5f, 1.25f);
                return InteractionResultHolder.success((Object)stack);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        return super.use(level, player, hand);
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.isBound(stack) ? super.getUseDuration(stack, entity) : 0;
    }

    public static boolean lightningStrike(LightningBolt bolt, Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack stack = itemEntity.getItem();
            if (stack.is((Item)GAGRegistry.HEARTHSTONE.get())) {
                ItemStack newStack = stack.transmuteCopy(GAGRegistry.ENERGIZED_HEARTHSTONE);
                float damage = (float)stack.getDamageValue() / (float)stack.getMaxDamage();
                newStack.setDamageValue((int)((float)newStack.getMaxDamage() * damage));
                itemEntity.setItem(newStack);
                bolt.hitEntities.add(entity);
                return true;
            }
            if (stack.is((Item)GAGRegistry.ENERGIZED_HEARTHSTONE.get())) {
                if (!bolt.hitEntities.contains(entity)) {
                    stack.remove(GAGRegistry.TELEPORT_TARGET_DATA);
                    float damage = (float)stack.getDamageValue() / (float)stack.getMaxDamage();
                    stack.setDamageValue((int)((double)stack.getMaxDamage() * Math.max(0.0, (double)damage - 0.25)));
                }
                itemEntity.setInvulnerable(true);
                bolt.hitEntities.add(entity);
                return true;
            }
        }
        return false;
    }
}

