/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.sammy.malum.core.handlers.hiding.HiddenTagHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GazeRevelationHandler {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(RevelationStage.class, (Object)new RevelationStage.Adapter()).create();
    private static boolean checkedFile = false;
    private static RevelationStage revelationStage = RevelationStage.NEOPHYTE;

    @OnlyIn(value=Dist.CLIENT)
    private static Path getPath() {
        return Minecraft.getInstance().gameDirectory.toPath().resolve("gaze_revelation.json");
    }

    private static void checkFile() {
        if (!checkedFile) {
            try {
                String content = Files.readString(GazeRevelationHandler.getPath(), StandardCharsets.UTF_8);
                RevelationData data = (RevelationData)GSON.fromJson(content, RevelationData.class);
                if (data != null) {
                    revelationStage = data.seenStage;
                }
            }
            catch (JsonSyntaxException | IOException e) {
                revelationStage = RevelationStage.NEOPHYTE;
            }
            checkedFile = true;
        }
    }

    public static boolean hasDiscoveredStage(RevelationStage stage) {
        GazeRevelationHandler.checkFile();
        return revelationStage.ordinal() >= stage.ordinal();
    }

    public static void discoverStage(RevelationStage stage) {
        if (!GazeRevelationHandler.hasDiscoveredStage(stage)) {
            revelationStage = stage;
            try {
                RevelationData data = new RevelationData();
                data.seenStage = stage;
                Files.writeString(GazeRevelationHandler.getPath(), (CharSequence)GSON.toJson((Object)data), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            HiddenTagHandler.conditionsChanged();
        }
    }

    private static class RevelationData {
        public RevelationStage seenStage;

        private RevelationData() {
        }
    }

    public static enum RevelationStage {
        NEOPHYTE,
        GAZE_APPRENTICE,
        GAZE_MASTER;


        private static class Adapter
        extends TypeAdapter<RevelationStage> {
            private Adapter() {
            }

            public void write(JsonWriter out, RevelationStage value) throws IOException {
                switch (value.ordinal()) {
                    case 0: {
                        out.value(false);
                        break;
                    }
                    case 1: {
                        out.value(true);
                        break;
                    }
                    case 2: {
                        out.value("all");
                    }
                }
            }

            public RevelationStage read(JsonReader in) throws IOException {
                JsonToken token = in.peek();
                if (token == JsonToken.BOOLEAN && in.nextBoolean()) {
                    return GAZE_APPRENTICE;
                }
                if (token == JsonToken.STRING && in.nextString().equals("all")) {
                    return GAZE_MASTER;
                }
                return NEOPHYTE;
            }
        }
    }
}

