/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.strawberry.gaze.GazeMod;
import com.strawberry.gaze.client.GazeModels;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class WheelCurioRenderer
implements ICurioRenderer {
    private static final ResourceLocation WHEEL = GazeMod.gazePath("textures/curio/ring.png");

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = slotContext.entity();
        WheelCurioRenderer.renderWheel(livingEntity, RenderType.entityTranslucent((ResourceLocation)WHEEL), poseStack, renderTypeBuffer, light);
    }

    public static void renderWheel(LivingEntity livingEntity, RenderType renderType, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light) {
        VertexConsumer vertexconsumer = renderTypeBuffer.getBuffer(renderType);
        poseStack.pushPose();
        ICurioRenderer.followHeadRotations((LivingEntity)livingEntity, (ModelPart[])new ModelPart[]{GazeModels.WHEEL.wheel});
        poseStack.mulPose(new Quaternionf().rotateX((float)Math.toRadians(-30.0)));
        GazeModels.WHEEL.renderToBuffer(poseStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
    }
}

