/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.geas.pact;

import com.google.common.collect.Multimap;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.strawberry.gaze.Config;
import com.strawberry.gaze.GazeMod;
import com.strawberry.gaze.registry.GazeGeasEffectTypeRegistry;
import com.strawberry.gaze.registry.GazeParticles;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;

public class EncroachingGeas
extends GeasEffect {
    private static final ResourceLocation ARMOR_CONVERSION_ID = GazeMod.gazePath("encroaching_convert_armor");
    private static final ResourceLocation TOUGHNESS_CONVERSION_ID = GazeMod.gazePath("encroaching_convert_toughness");
    private static final ResourceLocation HEALING_CONVERSION_ID = GazeMod.gazePath("encroaching_convert_healing");
    private static final ResourceLocation DAMAGE_CONVERSION_ID = GazeMod.gazePath("encroaching_convert_damage");

    public EncroachingGeas() {
        super((GeasEffectType)GazeGeasEffectTypeRegistry.PACT_OF_ENCROACHING.get());
    }

    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect((String)"armour_convert_soul_ward", (Object[])new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect((String)"toughness_convert_soul_integrity", (Object[])new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect((String)"healing_convert_soul_recovery", (Object[])new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect((String)"damage_convert_magic", (Object[])new Object[0]));
    }

    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        this.addAttributeModifier(modifiers, (Holder)MalumAttributes.MALIGNANT_CONVERSION, -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        return modifiers;
    }

    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        this.updateArmourConversion(entity, (Holder<Attribute>)Attributes.ARMOR, (DeferredHolder<Attribute, Attribute>)MalumAttributes.SOUL_WARD_CAPACITY, ARMOR_CONVERSION_ID);
        this.updateArmourConversion(entity, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, (DeferredHolder<Attribute, Attribute>)MalumAttributes.SOUL_WARD_INTEGRITY, TOUGHNESS_CONVERSION_ID);
        this.updateHealingConversion(entity, (DeferredHolder<Attribute, Attribute>)MalumAttributes.HEALING_MULTIPLIER, (DeferredHolder<Attribute, Attribute>)MalumAttributes.SOUL_WARD_RECOVERY_RATE, HEALING_CONVERSION_ID);
        for (ResourceLocation attrId : Config.getHealingConversionAttributes().keySet()) {
            entity.level().registryAccess().registryOrThrow(Registries.ATTRIBUTE).getOptional(attrId).ifPresent(attribute -> this.updateHealingConversion(entity, (Attribute)attribute, (DeferredHolder<Attribute, Attribute>)MalumAttributes.SOUL_WARD_RECOVERY_RATE, GazeMod.gazePath("encroaching_convert_" + attrId.getPath())));
        }
        this.updateDamageConversion(entity, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, (DeferredHolder<Attribute, Attribute>)LodestoneAttributes.MAGIC_DAMAGE, DAMAGE_CONVERSION_ID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnGeasHaloParticles(Level pLevel, LivingEntity pLivingEntity, float pct) {
        if (Config.fancyParticles) {
            Vec3 center = pLivingEntity.position().add(0.0, (double)pLivingEntity.getBbHeight() * 0.9, 0.0);
            float yawRad = (float)Math.toRadians(pLivingEntity.getYRot());
            Vec3 forwardHoriz = new Vec3(-Math.sin(yawRad), 0.0, Math.cos(yawRad)).normalize();
            double behindDistance = 0.0;
            Vec3 behind = center.subtract(forwardHoriz.scale(behindDistance));
            Vec3 right = new Vec3(forwardHoriz.z, 0.0, -forwardHoriz.x).normalize();
            double sideOffset = 0.0;
            Vec3 leftWingPos = behind.add(right.scale(sideOffset)).add(0.0, 0.55, 0.0);
            Vec3 leftDir = forwardHoriz.scale(-0.7).add(right.scale(0.0)).normalize();
            WorldParticleBuilder.create(GazeParticles.MALICE_HALO).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)leftDir)).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.33f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.25f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setColorData((ColorParticleDataWrapper)MalumSpiritTypes.UMBRAL_SPIRIT.createColorData().build()).enableForcedSpawn().setLifeDelay(2).setLifetime(2).enableNoClip().setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(pLevel, leftWingPos.x, leftWingPos.y, leftWingPos.z);
            WorldParticleBuilder.create(GazeParticles.MALICE_HALO).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)leftDir)).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.23f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.3f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setColorData((ColorParticleDataWrapper)MalumSpiritTypes.UMBRAL_SPIRIT.createColorData().build()).enableForcedSpawn().setLifeDelay(2).setLifetime(2).enableNoClip().setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.ADDITIVE).spawn(pLevel, leftWingPos.x, leftWingPos.y, leftWingPos.z);
        }
    }

    private void updateHealingConversion(LivingEntity entity, Attribute source, DeferredHolder<Attribute, Attribute> target, ResourceLocation modifierId) {
        AttributeInstance sourceInstance = entity.getAttribute(BuiltInRegistries.ATTRIBUTE.wrapAsHolder((Object)source));
        AttributeInstance targetInstance = entity.getAttribute(target);
        if (sourceInstance == null || targetInstance == null) {
            return;
        }
        targetInstance.removeModifier(modifierId);
        sourceInstance.removeModifier(modifierId);
        double sourceValue = sourceInstance.getValue();
        if (sourceValue > 1.0) {
            double excess = sourceValue - 1.0;
            targetInstance.addTransientModifier(new AttributeModifier(modifierId, excess, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            sourceInstance.addTransientModifier(new AttributeModifier(modifierId, -excess, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    private void updateDamageConversion(LivingEntity entity, Holder<Attribute> source, DeferredHolder<Attribute, Attribute> target, ResourceLocation modifierId) {
        AttributeInstance sourceInstance = entity.getAttribute(source);
        AttributeInstance targetInstance = entity.getAttribute(target);
        if (sourceInstance == null || targetInstance == null) {
            return;
        }
        targetInstance.removeModifier(modifierId);
        sourceInstance.removeModifier(modifierId);
        double sourceValue = sourceInstance.getValue();
        if (sourceValue >= 2.0) {
            double transferableAmount = sourceValue * 0.5;
            targetInstance.addTransientModifier(new AttributeModifier(modifierId, transferableAmount, AttributeModifier.Operation.ADD_VALUE));
            sourceInstance.addTransientModifier(new AttributeModifier(modifierId, -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
    }

    private void updateArmourConversion(LivingEntity entity, Holder<Attribute> source, DeferredHolder<Attribute, Attribute> target, ResourceLocation modifierId) {
        AttributeInstance sourceInstance = entity.getAttribute(source);
        AttributeInstance targetInstance = entity.getAttribute(target);
        if (sourceInstance == null || targetInstance == null) {
            return;
        }
        targetInstance.removeModifier(modifierId);
        sourceInstance.removeModifier(modifierId);
        double sourceValue = sourceInstance.getValue();
        if (sourceValue != 0.0) {
            double scaledValue = source == Attributes.ARMOR_TOUGHNESS ? sourceValue * Config.integrityRatio / 100.0 : sourceValue;
            targetInstance.addTransientModifier(new AttributeModifier(modifierId, scaledValue, AttributeModifier.Operation.ADD_VALUE));
            sourceInstance.addTransientModifier(new AttributeModifier(modifierId, -sourceValue, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    private void updateHealingConversion(LivingEntity entity, DeferredHolder<Attribute, Attribute> source, DeferredHolder<Attribute, Attribute> target, ResourceLocation modifierId) {
        AttributeInstance sourceInstance = entity.getAttribute(source);
        AttributeInstance targetInstance = entity.getAttribute(target);
        if (sourceInstance == null || targetInstance == null) {
            return;
        }
        targetInstance.removeModifier(modifierId);
        sourceInstance.removeModifier(modifierId);
        double sourceValue = sourceInstance.getValue();
        if (sourceValue > 1.0) {
            double excess = sourceValue - 1.0;
            targetInstance.addTransientModifier(new AttributeModifier(modifierId, excess, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            double correction = 1.0 - sourceValue;
            sourceInstance.addTransientModifier(new AttributeModifier(modifierId, correction, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    public void removeAttributeModifiers(LivingEntity entity) {
        super.removeAttributeModifiers(entity);
        this.removeModifierIfPresent(entity, (Holder<Attribute>)Attributes.ARMOR, ARMOR_CONVERSION_ID);
        this.removeModifierIfPresent(entity, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, TOUGHNESS_CONVERSION_ID);
        this.removeModifierIfPresent(entity, (Holder<Attribute>)MalumAttributes.HEALING_MULTIPLIER, HEALING_CONVERSION_ID);
        this.removeModifierIfPresent(entity, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, DAMAGE_CONVERSION_ID);
        this.removeModifierIfPresent(entity, (Holder<Attribute>)LodestoneAttributes.MAGIC_DAMAGE, DAMAGE_CONVERSION_ID);
        this.removeModifierIfPresent(entity, (Holder<Attribute>)MalumAttributes.SOUL_WARD_CAPACITY, ARMOR_CONVERSION_ID);
        this.removeModifierIfPresent(entity, (Holder<Attribute>)MalumAttributes.SOUL_WARD_INTEGRITY, TOUGHNESS_CONVERSION_ID);
        this.removeModifierIfPresent(entity, (Holder<Attribute>)MalumAttributes.SOUL_WARD_RECOVERY_RATE, HEALING_CONVERSION_ID);
        for (ResourceLocation attrId : Config.getHealingConversionAttributes().keySet()) {
            ResourceLocation modifierId = GazeMod.gazePath("encroaching_convert_" + attrId.getPath());
            entity.level().registryAccess().registryOrThrow(Registries.ATTRIBUTE).getOptional(attrId).ifPresent(attribute -> {
                this.removeModifierIfPresent(entity, (Holder<Attribute>)BuiltInRegistries.ATTRIBUTE.wrapAsHolder(attribute), modifierId);
                this.removeModifierIfPresent(entity, (Holder<Attribute>)MalumAttributes.SOUL_WARD_RECOVERY_RATE, modifierId);
            });
        }
    }

    private void removeModifierIfPresent(LivingEntity entity, Holder<Attribute> attributeHolder, ResourceLocation modifierId) {
        AttributeInstance attributeInstance = entity.getAttribute(attributeHolder);
        if (attributeInstance != null) {
            attributeInstance.removeModifier(modifierId);
        }
    }
}

