/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.effect;

import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GazeLesserInfernalRiteEffect
extends SpiritRiteBlockEffect {
    public GazeLesserInfernalRiteEffect() {
        super(new SpiritRiteEffectTag[]{SpiritRiteEffectTag.LESSER_RITE});
    }

    public void applyEffect(ServerLevel level, BlockRiteEffectActivatorEntity activator, BlockState state, BlockPos pos, float potency) {
        int radius = Math.max(0, (int)potency - 1);
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos targetPos = pos.offset(dx, 0, dz);
                BlockState targetState = level.getBlockState(targetPos);
                if (!targetState.is(Blocks.STONE)) continue;
                level.setBlockAndUpdate(targetPos, Blocks.NETHERRACK.defaultBlockState());
                this.createEffect(level, targetPos, List.of(MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.EARTHEN_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT));
            }
        }
    }
}

