/*
 * Decompiled with CFR 0.152.
 */
package guideme;

import guideme.Guide;
import guideme.GuideItemSettings;
import guideme.extensions.Extension;
import guideme.extensions.ExtensionCollection;
import guideme.extensions.ExtensionPoint;
import guideme.indices.CategoryIndex;
import guideme.indices.ItemIndex;
import guideme.indices.PageIndex;
import guideme.internal.GuideRegistry;
import guideme.internal.MutableGuide;
import guideme.internal.extensions.DefaultExtensions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class GuideBuilder {
    private final ResourceLocation id;
    private final Map<Class<?>, PageIndex> indices = new IdentityHashMap();
    private final ExtensionCollection.Builder extensionsBuilder = ExtensionCollection.builder();
    private String defaultNamespace;
    private String defaultLanguage = "en_us";
    private String folder;
    private ResourceLocation startPage;
    private Path developmentSourceFolder;
    private String developmentSourceNamespace;
    private boolean watchDevelopmentSources = true;
    private boolean disableDefaultExtensions = false;
    private boolean availableToOpenHotkey = true;
    private final Set<ExtensionPoint<?>> disableDefaultsForExtensionPoints = Collections.newSetFromMap(new IdentityHashMap());
    private boolean register = true;
    private GuideItemSettings itemSettings = GuideItemSettings.DEFAULT;

    GuideBuilder(ResourceLocation id) {
        this.id = Objects.requireNonNull(id, "id");
        this.defaultNamespace = id.getNamespace();
        this.folder = "guides/" + id.getNamespace() + "/" + id.getPath();
        this.startPage = ResourceLocation.fromNamespaceAndPath((String)this.defaultNamespace, (String)"index.md");
        String devSourcesFolderProperty = GuideBuilder.getSystemPropertyName(id, "sources");
        String devSourcesNamespaceProperty = GuideBuilder.getSystemPropertyName(id, "sourcesNamespace");
        String sourceFolder = System.getProperty(devSourcesFolderProperty);
        if (sourceFolder != null) {
            this.developmentSourceFolder = Paths.get(sourceFolder, new String[0]);
            this.developmentSourceNamespace = System.getProperty(devSourcesNamespaceProperty, this.defaultNamespace);
        }
        this.index(new ItemIndex());
        this.index(new CategoryIndex());
    }

    public GuideBuilder register(boolean enable) {
        this.register = enable;
        return this;
    }

    public GuideBuilder defaultNamespace(String defaultNamespace) {
        if (!ResourceLocation.isValidNamespace((String)defaultNamespace)) {
            throw new IllegalArgumentException("The default namespace for a guide needs to be a valid namespace");
        }
        this.defaultNamespace = defaultNamespace;
        return this;
    }

    public GuideBuilder folder(String folder) {
        if (!ResourceLocation.isValidPath((String)folder)) {
            throw new IllegalArgumentException("The folder for a guide needs to be a valid resource location");
        }
        this.folder = folder;
        return this;
    }

    public GuideBuilder defaultLanguage(String languageCode) {
        this.defaultLanguage = languageCode;
        return this;
    }

    public GuideBuilder disableDefaultExtensions() {
        this.disableDefaultExtensions = true;
        return this;
    }

    public GuideBuilder disableOpenHotkey() {
        this.availableToOpenHotkey = false;
        return this;
    }

    public GuideBuilder disableDefaultExtensions(ExtensionPoint<?> extensionPoint) {
        this.disableDefaultsForExtensionPoints.add(extensionPoint);
        return this;
    }

    public GuideBuilder startPage(ResourceLocation pageId) {
        this.startPage = pageId;
        return this;
    }

    public GuideBuilder developmentSources(@Nullable Path folder) {
        return this.developmentSources(folder, this.defaultNamespace);
    }

    public GuideBuilder developmentSources(Path folder, String namespace) {
        this.developmentSourceFolder = folder;
        this.developmentSourceNamespace = namespace;
        return this;
    }

    public GuideBuilder watchDevelopmentSources(boolean enable) {
        this.watchDevelopmentSources = enable;
        return this;
    }

    public GuideBuilder index(PageIndex index) {
        this.indices.put(index.getClass(), index);
        return this;
    }

    public <T extends PageIndex> GuideBuilder index(Class<? super T> clazz, T index) {
        this.indices.put(clazz, index);
        return this;
    }

    public <T extends Extension> GuideBuilder extension(ExtensionPoint<T> extensionPoint, T extension) {
        this.extensionsBuilder.add(extensionPoint, extension);
        return this;
    }

    public GuideBuilder itemSettings(GuideItemSettings settings) {
        this.itemSettings = settings;
        return this;
    }

    public Guide build() {
        ExtensionCollection extensionCollection = this.buildExtensions();
        MutableGuide guide = new MutableGuide(this.id, this.defaultNamespace, this.folder, this.defaultLanguage, this.startPage, this.developmentSourceFolder, this.developmentSourceNamespace, this.indices, extensionCollection, this.availableToOpenHotkey, this.itemSettings);
        if (this.developmentSourceFolder != null && this.watchDevelopmentSources) {
            guide.watchDevelopmentSources();
        }
        if (this.register) {
            GuideRegistry.registerStatic(guide);
        }
        return guide;
    }

    private ExtensionCollection buildExtensions() {
        ExtensionCollection.Builder builder = ExtensionCollection.builder();
        if (!this.disableDefaultExtensions) {
            DefaultExtensions.addAll(builder, this.disableDefaultsForExtensionPoints);
        }
        builder.addAll(this.extensionsBuilder);
        return builder.build();
    }

    private static String getSystemPropertyName(ResourceLocation guideId, String property) {
        return String.format(Locale.ROOT, "guideme.%s.%s.%s", guideId.getNamespace(), guideId.getPath(), property);
    }
}

