/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.lucene101;

import guideme.internal.shaded.lucene.codecs.lucene101.ForUtil;
import guideme.internal.shaded.lucene.internal.vectorization.PostingDecodingUtil;
import guideme.internal.shaded.lucene.store.DataInput;
import guideme.internal.shaded.lucene.store.DataOutput;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.util.LongHeap;
import guideme.internal.shaded.lucene.util.packed.PackedInts;
import java.io.IOException;
import java.util.Arrays;

final class PForUtil {
    private static final int MAX_EXCEPTIONS = 7;
    private final ForUtil forUtil = new ForUtil();

    PForUtil() {
    }

    static boolean allEqual(int[] l) {
        for (int i = 1; i < 128; ++i) {
            if (l[i] == l[0]) continue;
            return false;
        }
        return true;
    }

    void encode(int[] ints, DataOutput out) throws IOException {
        LongHeap top = new LongHeap(8);
        for (int i = 0; i <= 7; ++i) {
            top.push(ints[i]);
        }
        long topValue = top.top();
        for (int i = 8; i < 128; ++i) {
            if ((long)ints[i] <= topValue) continue;
            topValue = top.updateTop(ints[i]);
        }
        long max = 0L;
        for (int i = 1; i <= top.size(); ++i) {
            max = Math.max(max, top.get(i));
        }
        int maxBitsRequired = PackedInts.bitsRequired(max);
        int patchedBitsRequired = Math.max(PackedInts.bitsRequired(topValue), maxBitsRequired - 8);
        int numExceptions = 0;
        long maxUnpatchedValue = (1L << patchedBitsRequired) - 1L;
        for (int i = 2; i <= top.size(); ++i) {
            if (top.get(i) <= maxUnpatchedValue) continue;
            ++numExceptions;
        }
        byte[] exceptions = new byte[numExceptions * 2];
        if (numExceptions > 0) {
            int exceptionCount = 0;
            for (int i = 0; i < 128; ++i) {
                if ((long)ints[i] <= maxUnpatchedValue) continue;
                exceptions[exceptionCount * 2] = (byte)i;
                exceptions[exceptionCount * 2 + 1] = (byte)(ints[i] >>> patchedBitsRequired);
                int n = i;
                ints[n] = (int)((long)ints[n] & maxUnpatchedValue);
                ++exceptionCount;
            }
            assert (exceptionCount == numExceptions) : exceptionCount + " " + numExceptions;
        }
        if (PForUtil.allEqual(ints) && maxBitsRequired <= 8) {
            for (int i = 0; i < numExceptions; ++i) {
                exceptions[2 * i + 1] = (byte)(Byte.toUnsignedLong(exceptions[2 * i + 1]) << patchedBitsRequired);
            }
            out.writeByte((byte)(numExceptions << 5));
            out.writeVInt(ints[0]);
        } else {
            int token = numExceptions << 5 | patchedBitsRequired;
            out.writeByte((byte)token);
            this.forUtil.encode(ints, patchedBitsRequired, out);
        }
        out.writeBytes(exceptions, exceptions.length);
    }

    void decode(PostingDecodingUtil pdu, int[] ints) throws IOException {
        IndexInput in = pdu.in;
        int token = Byte.toUnsignedInt(in.readByte());
        int bitsPerValue = token & 0x1F;
        if (bitsPerValue == 0) {
            Arrays.fill(ints, 0, 128, in.readVInt());
        } else {
            this.forUtil.decode(bitsPerValue, pdu, ints);
        }
        int numExceptions = token >>> 5;
        for (int i = 0; i < numExceptions; ++i) {
            int n = Byte.toUnsignedInt(in.readByte());
            ints[n] = (int)((long)ints[n] | Byte.toUnsignedLong(in.readByte()) << bitsPerValue);
        }
    }

    static void skip(DataInput in) throws IOException {
        int token = Byte.toUnsignedInt(in.readByte());
        int bitsPerValue = token & 0x1F;
        int numExceptions = token >>> 5;
        if (bitsPerValue == 0) {
            in.readVLong();
            in.skipBytes(numExceptions << 1);
        } else {
            in.skipBytes(ForUtil.numBytes(bitsPerValue) + (numExceptions << 1));
        }
    }
}

