/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.taxonomy;

import guideme.internal.shaded.lucene.facet.FacetsConfig;
import guideme.internal.shaded.lucene.index.FilterLeafReader;
import guideme.internal.shaded.lucene.index.FilterSortedNumericDocValues;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.internal.hppc.IntArrayList;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class OrdinalMappingLeafReader
extends FilterLeafReader {
    private final int[] ordinalMap;
    private final Set<String> facetFields;

    public OrdinalMappingLeafReader(LeafReader in, int[] ordinalMap, FacetsConfig srcConfig) {
        super(in);
        this.ordinalMap = ordinalMap;
        this.facetFields = new HashSet<String>();
        for (FacetsConfig.DimConfig dc : srcConfig.getDimConfigs().values()) {
            this.facetFields.add(dc.indexFieldName);
        }
        this.facetFields.add(FacetsConfig.DEFAULT_DIM_CONFIG.indexFieldName);
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        SortedNumericDocValues original = this.in.getSortedNumericDocValues(field);
        if (original != null && this.facetFields.contains(field)) {
            return new OrdinalMappingSortedNumericDocValues(original);
        }
        return original;
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    private class OrdinalMappingSortedNumericDocValues
    extends FilterSortedNumericDocValues {
        private final IntArrayList currentValues;
        private int currIndex;

        OrdinalMappingSortedNumericDocValues(SortedNumericDocValues in) {
            super(in);
            this.currentValues = new IntArrayList(32);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            boolean result = this.in.advanceExact(target);
            if (result) {
                this.reloadValues();
            }
            return result;
        }

        @Override
        public int advance(int target) throws IOException {
            int result = this.in.advance(target);
            if (result != Integer.MAX_VALUE) {
                this.reloadValues();
            }
            return result;
        }

        @Override
        public int nextDoc() throws IOException {
            int result = this.in.nextDoc();
            if (result != Integer.MAX_VALUE) {
                this.reloadValues();
            }
            return result;
        }

        @Override
        public int docValueCount() {
            return this.currentValues.elementsCount;
        }

        private void reloadValues() throws IOException {
            this.currIndex = 0;
            this.currentValues.clear();
            for (int i = 0; i < this.in.docValueCount(); ++i) {
                int originalOrd = Math.toIntExact(this.in.nextValue());
                this.currentValues.add(OrdinalMappingLeafReader.this.ordinalMap[originalOrd]);
            }
            Arrays.sort(this.currentValues.buffer, 0, this.currentValues.elementsCount);
        }

        @Override
        public long nextValue() {
            assert (this.currIndex < this.currentValues.size());
            int actual = this.currentValues.get(this.currIndex);
            ++this.currIndex;
            return actual;
        }
    }
}

