/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.Scorable;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.ScorerUtil;
import guideme.internal.shaded.lucene.search.TwoPhaseIterator;
import java.util.Objects;

public class DisiWrapper {
    public final DocIdSetIterator iterator;
    public final Scorer scorer;
    public final Scorable scorable;
    public final long cost;
    public final float matchCost;
    public int doc;
    public DisiWrapper next;
    public final DocIdSetIterator approximation;
    public final TwoPhaseIterator twoPhaseView;
    long scaledMaxScore;
    float maxWindowScore;

    public DisiWrapper(Scorer scorer, boolean impacts) {
        this.scorer = Objects.requireNonNull(scorer);
        this.scorable = ScorerUtil.likelyTermScorer(scorer);
        this.iterator = impacts ? ScorerUtil.likelyImpactsEnum(scorer.iterator()) : scorer.iterator();
        this.cost = this.iterator.cost();
        this.doc = -1;
        this.twoPhaseView = scorer.twoPhaseIterator();
        if (this.twoPhaseView != null) {
            this.approximation = this.twoPhaseView.approximation();
            this.matchCost = this.twoPhaseView.matchCost();
        } else {
            this.approximation = this.iterator;
            this.matchCost = 0.0f;
        }
    }
}

