/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.Impact;
import guideme.internal.shaded.lucene.index.Impacts;
import guideme.internal.shaded.lucene.index.ImpactsSource;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class MaxScoreCache {
    private final ImpactsSource impactsSource;
    private final Similarity.SimScorer scorer;
    private final float globalMaxScore;
    private float[] maxScoreCache;
    private int[] maxScoreCacheUpTo;

    public MaxScoreCache(ImpactsSource impactsSource, Similarity.SimScorer scorer) {
        this.impactsSource = impactsSource;
        this.scorer = scorer;
        this.globalMaxScore = scorer.score(Float.MAX_VALUE, 1L);
        this.maxScoreCache = new float[0];
        this.maxScoreCacheUpTo = new int[0];
    }

    public int advanceShallow(int target) throws IOException {
        this.impactsSource.advanceShallow(target);
        Impacts impacts = this.impactsSource.getImpacts();
        return impacts.getDocIdUpTo(0);
    }

    private void ensureCacheSize(int size) {
        if (this.maxScoreCache.length < size) {
            int oldLength = this.maxScoreCache.length;
            this.maxScoreCache = ArrayUtil.grow(this.maxScoreCache, size);
            this.maxScoreCacheUpTo = ArrayUtil.growExact(this.maxScoreCacheUpTo, this.maxScoreCache.length);
            Arrays.fill(this.maxScoreCacheUpTo, oldLength, this.maxScoreCacheUpTo.length, -1);
        }
    }

    private float computeMaxScore(List<Impact> impacts) {
        float maxScore = 0.0f;
        Similarity.SimScorer scorer = this.scorer;
        int length = impacts.size();
        for (int i = 0; i < length; ++i) {
            Impact impact = impacts.get(i);
            maxScore = Math.max(scorer.score(impact.freq, impact.norm), maxScore);
        }
        return maxScore;
    }

    public float getMaxScore(int upTo) throws IOException {
        int level = this.getLevel(upTo);
        if (level == -1) {
            return this.globalMaxScore;
        }
        return this.getMaxScoreForLevel(level);
    }

    private int getLevel(int upTo) throws IOException {
        Impacts impacts = this.impactsSource.getImpacts();
        int numLevels = impacts.numLevels();
        for (int level = 0; level < numLevels; ++level) {
            int impactsUpTo = impacts.getDocIdUpTo(level);
            if (upTo > impactsUpTo) continue;
            return level;
        }
        return -1;
    }

    float getMaxScoreForLevelZero() throws IOException {
        return this.getMaxScoreForLevel(0);
    }

    private float getMaxScoreForLevel(int level) throws IOException {
        assert (level >= 0) : "level must not be a negative integer; got " + level;
        Impacts impacts = this.impactsSource.getImpacts();
        this.ensureCacheSize(level + 1);
        int levelUpTo = impacts.getDocIdUpTo(level);
        if (this.maxScoreCacheUpTo[level] < levelUpTo) {
            this.maxScoreCache[level] = this.computeMaxScore(impacts.getImpacts(level));
            this.maxScoreCacheUpTo[level] = levelUpTo;
        }
        return this.maxScoreCache[level];
    }

    private int getSkipLevel(Impacts impacts, float minScore) throws IOException {
        int numLevels = impacts.numLevels();
        for (int level = 0; level < numLevels; ++level) {
            if (!(this.getMaxScoreForLevel(level) >= minScore)) continue;
            return level - 1;
        }
        return numLevels - 1;
    }

    int getSkipUpTo(float minScore) throws IOException {
        Impacts impacts = this.impactsSource.getImpacts();
        int level = this.getSkipLevel(impacts, minScore);
        if (level == -1) {
            return -1;
        }
        return impacts.getDocIdUpTo(level);
    }
}

