/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic.util;

import dev.muon.irons_apothic.IronsApothic;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.neoforged.fml.ModList;
import org.objectweb.asm.Type;

public class SpellDiscoveryUtil {
    public static void logAvailableSpells() {
        List<AbstractSpell> spells = SpellDiscoveryUtil.getAvailableSpells();
        IronsApothic.LOGGER.info("=== Available Spells for Spell Trigger Affixes ===");
        Map<SchoolType, List<AbstractSpell>> spellsBySchool = spells.stream().collect(Collectors.groupingBy(AbstractSpell::getSchoolType));
        spellsBySchool.forEach((school, schoolSpells) -> {
            IronsApothic.LOGGER.info("\n{} School:", (Object)school.getDisplayName().getString());
            schoolSpells.forEach(spell -> IronsApothic.LOGGER.info("  - {} ({}): Level {}-{}, Cast Type: {}", (Object)spell.getSpellName(), (Object)spell.getSpellId(), (Object)spell.getMinLevel(), (Object)spell.getMaxLevel(), (Object)spell.getCastType()));
        });
        IronsApothic.LOGGER.info("\n=== Potential Buff/Utility Spells ===");
        spells.stream().filter(spell -> spell.getCastType() == CastType.INSTANT).filter(spell -> !spell.getSpellName().contains("bolt") && !spell.getSpellName().contains("slash") && !spell.getSpellName().contains("arrow")).forEach(spell -> IronsApothic.LOGGER.info("  - {} ({})", (Object)spell.getSpellName(), (Object)spell.getSpellId()));
    }

    public static List<AbstractSpell> getAvailableSpells() {
        List allScanData = ModList.get().getAllScanData();
        HashSet spellClassNames = new HashSet();
        allScanData.forEach(scanData -> scanData.getAnnotations().forEach(annotationData -> {
            if (Objects.equals(annotationData.annotationType(), Type.getType(AutoSpellConfig.class))) {
                spellClassNames.add(annotationData.memberName());
            }
        }));
        ArrayList<AbstractSpell> spells = new ArrayList<AbstractSpell>();
        spellClassNames.forEach(spellName -> {
            try {
                Class<?> pluginClass = Class.forName(spellName);
                Class<AbstractSpell> pluginClassSubclass = pluginClass.asSubclass(AbstractSpell.class);
                Constructor<AbstractSpell> constructor = pluginClassSubclass.getDeclaredConstructor(new Class[0]);
                AbstractSpell instance = constructor.newInstance(new Object[0]);
                spells.add(instance);
            }
            catch (Exception e) {
                IronsApothic.LOGGER.error("SpellDiscovery error for {}: {}", spellName, (Object)e.getMessage());
            }
        });
        return spells;
    }
}

