/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AppendLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<AppendLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(builder -> AppendLootModifier.codecStart((RecordCodecBuilder.Instance)builder).and((App)Codec.list((Codec)Codec.STRING).fieldOf("keys").forGetter(m -> m.resourceLocationKeys)).apply((Applicative)builder, AppendLootModifier::new)));
    private final List<String> resourceLocationKeys;

    protected AppendLootModifier(LootItemCondition[] conditionsIn, List<String> resourceLocationKey) {
        super(conditionsIn);
        this.resourceLocationKeys = resourceLocationKey;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (String resourceLocation : this.resourceLocationKeys) {
            ResourceLocation path = ResourceLocation.parse((String)resourceLocation);
            LootTable lootTable = context.getLevel().getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)path));
            ObjectArrayList objectarraylist = new ObjectArrayList();
            lootTable.getRandomItemsRaw(context, arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0));
            generatedLoot.addAll((ObjectList)objectarraylist);
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

