/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0003H\u0014J(\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/BlockOfSticksBlock;", "Lnet/minecraft/world/level/block/Block;", "returning", "", "<init>", "(Z)V", "getReturning", "()Z", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/state/BlockState;", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "onPlace", "pState", "pLevel", "Lnet/minecraft/world/level/Level;", "pPos", "Lnet/minecraft/core/BlockPos;", "pOldState", "pMovedByPiston", "tick", "level", "Lnet/minecraft/server/level/ServerLevel;", "pos", "random", "Lnet/minecraft/util/RandomSource;", "Companion", "irregular-implements-1.21.1"})
public final class BlockOfSticksBlock
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean returning;
    @NotNull
    private static final BooleanProperty SHOULD_DROP;

    public BlockOfSticksBlock(boolean returning) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).sound(SoundType.SCAFFOLDING).strength(0.3f).pushReaction(PushReaction.DESTROY).isRedstoneConductor(Blocks::never).isValidSpawn((p0$p0, p1$p1, p2$p2, p3$p3) -> Blocks.never((BlockState)p0$p0, (BlockGetter)p1$p1, (BlockPos)p2$p2, (EntityType)p3$p3)).isSuffocating(Blocks::never).isViewBlocking(Blocks::never).noOcclusion());
        this.returning = returning;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)SHOULD_DROP, (Comparable)Boolean.valueOf(true)));
    }

    public final boolean getReturning() {
        return this.returning;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{SHOULD_DROP};
        builder.add(propertyArray);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.getPlayer();
        return (BlockState)this.defaultBlockState().setValue((Property)SHOULD_DROP, (Comparable)Boolean.valueOf(AaronExtensions.INSTANCE.isNotTrue(player != null ? Boolean.valueOf(player.hasInfiniteMaterials()) : null)));
    }

    protected void onPlace(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pMovedByPiston) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pOldState, (String)"pOldState");
        if (!pLevel.isClientSide) {
            pLevel.scheduleTick(pPos, (Block)this, 140);
        }
        super.onPlace(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }

    protected void tick(@NotNull BlockState pState, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Boolean shouldDrop = (Boolean)pState.getValue((Property)SHOULD_DROP);
        if (!this.returning) {
            Intrinsics.checkNotNull((Object)shouldDrop);
            level.destroyBlock(pos, shouldDrop.booleanValue());
            super.tick(pState, level, pos, random);
            return;
        }
        if (shouldDrop.booleanValue() && !level.isClientSide && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && !level.restoringBlockSnapshots) {
            Player nearestPlayer = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 100.0, false);
            Player player = nearestPlayer;
            if (player == null || (player = player.position()) == null) {
                player = pos.getCenter();
            }
            Player dropPos = player;
            List drops = Block.getDrops((BlockState)pState, (ServerLevel)level, (BlockPos)pos, null);
            for (ItemStack drop : drops) {
                ItemEntity itemEntity = new ItemEntity((Level)level, dropPos.x, dropPos.y, dropPos.z, drop);
                itemEntity.setNoPickUpDelay();
                level.addFreshEntity((Entity)itemEntity);
                if (nearestPlayer == null) continue;
                itemEntity.playerTouch(nearestPlayer);
            }
        }
        level.destroyBlock(pos, false);
        super.tick(pState, level, pos, random);
    }

    static {
        BooleanProperty booleanProperty = BooleanProperty.create((String)"should_drop");
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"create(...)");
        SHOULD_DROP = booleanProperty;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/BlockOfSticksBlock$Companion;", "", "<init>", "()V", "SHOULD_DROP", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getSHOULD_DROP", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanProperty getSHOULD_DROP() {
            return SHOULD_DROP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

