/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.irregular_implements.block.block_entity.DiaphanousBlockEntity;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModBlockTagsProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlocks;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0014J(\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J(\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0014J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\u001a"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/DiaphanousBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/EntityBlock;", "<init>", "()V", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "getOcclusionShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "level", "Lnet/minecraft/world/level/BlockGetter;", "getShape", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "getCollisionShape", "getShadeBrightness", "", "propagatesSkylightDown", "", "Companion", "irregular-implements-1.21.1"})
public final class DiaphanousBlock
extends Block
implements EntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VoxelShape SHAPE_EMPTY;
    @NotNull
    private static final VoxelShape SHAPE_FULL;

    public DiaphanousBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.STONE)).noOcclusion().isViewBlocking(Companion::isUsuallySolid).isSuffocating(Companion::isUsuallySolid));
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new DiaphanousBlockEntity(pos, state);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    protected VoxelShape getOcclusionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return SHAPE_EMPTY;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        DiaphanousBlockEntity blockEntity;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(context instanceof EntityCollisionContext)) {
            VoxelShape voxelShape = Shapes.empty();
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"empty(...)");
            return voxelShape;
        }
        Entity entity = ((EntityCollisionContext)context).getEntity();
        Player player = entity instanceof Player ? (Player)entity : null;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        DiaphanousBlockEntity diaphanousBlockEntity = blockEntity = blockEntity2 instanceof DiaphanousBlockEntity ? (DiaphanousBlockEntity)blockEntity2 : null;
        if (blockEntity == null || player == null) {
            VoxelShape voxelShape = Shapes.block();
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"block(...)");
            return voxelShape;
        }
        double distanceAllowed = 4.5;
        boolean closeEnough = player.getEyePosition().closerThan((Position)pos.getCenter(), distanceAllowed);
        boolean canInteract = closeEnough == blockEntity.isInverted() || player.isSecondaryUseActive() || player.isHolding(DiaphanousBlock::getShape$lambda$0);
        return canInteract ? SHAPE_FULL : SHAPE_EMPTY;
    }

    @NotNull
    protected VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Companion.isUsuallySolid(state, level, pos) ? SHAPE_FULL : SHAPE_EMPTY;
    }

    protected float getShadeBrightness(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return 1.0f;
    }

    protected boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    private static final boolean getShape$lambda$0(ItemStack it) {
        return it.is(ModBlocks.INSTANCE.getDIAPHANOUS_BLOCK().asItem());
    }

    static {
        VoxelShape voxelShape = Shapes.empty();
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"empty(...)");
        SHAPE_EMPTY = voxelShape;
        VoxelShape voxelShape2 = Shapes.block();
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"block(...)");
        SHAPE_FULL = voxelShape2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/DiaphanousBlock$Companion;", "", "<init>", "()V", "isValidBlock", "", "block", "Lnet/minecraft/world/level/block/Block;", "level", "Lnet/minecraft/world/level/Level;", "isUsuallySolid", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockGetter", "Lnet/minecraft/world/level/BlockGetter;", "blockPos", "Lnet/minecraft/core/BlockPos;", "SHAPE_EMPTY", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "SHAPE_FULL", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isValidBlock(@NotNull Block block, @NotNull Level level) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            try {
                bl = block.defaultBlockState().getRenderShape() == RenderShape.MODEL && Intrinsics.areEqual((Object)block.defaultBlockState().getCollisionShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO), (Object)Shapes.block()) && !block.defaultBlockState().is(ModBlockTagsProvider.Companion.getDIAPHANOUS_BLOCK_BLACKLIST());
            }
            catch (Exception e) {
                bl = false;
            }
            return bl;
        }

        public final boolean isUsuallySolid(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos) {
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)blockGetter, (String)"blockGetter");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            BlockEntity blockEntity = blockGetter.getBlockEntity(blockPos);
            return blockEntity instanceof DiaphanousBlockEntity ? ((DiaphanousBlockEntity)blockEntity).isInverted() : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

