/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.client;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/NotificationToast;", "Lnet/minecraft/client/gui/components/toasts/Toast;", "title", "", "description", "icon", "Lnet/minecraft/world/item/ItemStack;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/world/item/ItemStack;)V", "render", "Lnet/minecraft/client/gui/components/toasts/Toast$Visibility;", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "toastComponent", "Lnet/minecraft/client/gui/components/toasts/ToastComponent;", "timeSinceLastVisible", "", "Companion", "irregular-implements-1.21.1"})
public final class NotificationToast
implements Toast {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String title;
    @NotNull
    private final String description;
    @Nullable
    private final ItemStack icon;
    @NotNull
    private static final ResourceLocation BACKGROUND_SPRITE;
    private static final int DISPLAY_TIME = 5000;

    public NotificationToast(@NotNull String title, @NotNull String description, @Nullable ItemStack icon) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.title = title;
        this.description = description;
        this.icon = icon;
    }

    @NotNull
    public Toast.Visibility render(@NotNull GuiGraphics guiGraphics, @NotNull ToastComponent toastComponent, long timeSinceLastVisible) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)toastComponent, (String)"toastComponent");
        if (timeSinceLastVisible > 5000L) {
            return Toast.Visibility.HIDE;
        }
        guiGraphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        if (this.icon != null) {
            guiGraphics.renderFakeItem(this.icon, 8, 8);
        }
        Font font = toastComponent.getMinecraft().font;
        guiGraphics.drawString(font, this.title, 30, 7, -197632, false);
        guiGraphics.drawString(font, this.description, 30, 18, -197380, false);
        boolean shouldHide = (double)timeSinceLastVisible >= (double)5000 * toastComponent.getNotificationDisplayTimeMultiplier();
        return shouldHide ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    static {
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)"toast/advancement");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"withDefaultNamespace(...)");
        BACKGROUND_SPRITE = resourceLocation;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/NotificationToast$Companion;", "", "<init>", "()V", "BACKGROUND_SPRITE", "Lnet/minecraft/resources/ResourceLocation;", "DISPLAY_TIME", "", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

