/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.datagen.modonomicon.entries;

import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 .2\u00020\u0001:\u0001.B'\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tB'\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0004\b\b\u0010\u000bB+\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u000eB+\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u000f\u0012\u0006\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u0010B+\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0011\u0012\u0006\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u0012J\b\u0010\u0019\u001a\u00020\u0005H\u0014J\b\u0010\r\u001a\u00020\u0005H\u0014J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u0005H\u0014J\u0016\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0016\u0010\"\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\u0005J\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005J\u001e\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0005J\u000e\u0010(\u001a\u00020)2\u0006\u0010!\u001a\u00020\u0005J\u0016\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005J\u0016\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0005J\u001e\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005J\u0016\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u0010!\u001a\u00020\u0005J\u001e\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010#\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Ldev/aaronhowser/mods/irregular_implements/datagen/modonomicon/entries/BaseEntryProvider;", "Lcom/klikli_dev/modonomicon/api/datagen/EntryProvider;", "parent", "Lcom/klikli_dev/modonomicon/api/datagen/CategoryProviderBase;", "name", "", "icon", "Lnet/neoforged/neoforge/registries/DeferredItem;", "<init>", "(Lcom/klikli_dev/modonomicon/api/datagen/CategoryProviderBase;Ljava/lang/String;Lnet/neoforged/neoforge/registries/DeferredItem;)V", "Lnet/neoforged/neoforge/registries/DeferredBlock;", "(Lcom/klikli_dev/modonomicon/api/datagen/CategoryProviderBase;Ljava/lang/String;Lnet/neoforged/neoforge/registries/DeferredBlock;)V", "Lnet/minecraft/resources/ResourceLocation;", "entryId", "(Lcom/klikli_dev/modonomicon/api/datagen/CategoryProviderBase;Ljava/lang/String;Lnet/minecraft/resources/ResourceLocation;Ljava/lang/String;)V", "Lnet/minecraft/world/item/ItemStack;", "(Lcom/klikli_dev/modonomicon/api/datagen/CategoryProviderBase;Ljava/lang/String;Lnet/minecraft/world/item/ItemStack;Ljava/lang/String;)V", "Lnet/minecraft/world/level/ItemLike;", "(Lcom/klikli_dev/modonomicon/api/datagen/CategoryProviderBase;Ljava/lang/String;Lnet/minecraft/world/level/ItemLike;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getEntryId", "Lcom/mojang/datafixers/util/Either;", "getIcon", "()Lcom/mojang/datafixers/util/Either;", "entryName", "entryBackground", "Lcom/mojang/datafixers/util/Pair;", "", "entryIcon", "Lcom/klikli_dev/modonomicon/api/datagen/book/BookIconModel;", "entryDescription", "block", "text", "item", "pageIndex", "textPage", "Lcom/klikli_dev/modonomicon/api/datagen/book/page/BookTextPageModel;", "title", "pageId", "spotlightPage", "Lcom/klikli_dev/modonomicon/api/datagen/book/page/BookSpotlightPageModel;", "itemLike", "itemStack", "ingredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "Companion", "irregular-implements-1.21.1"})
public abstract class BaseEntryProvider
extends EntryProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String entryId;
    @NotNull
    private final Either<ResourceLocation, ItemStack> icon;
    private int pageIndex;

    public BaseEntryProvider(@Nullable CategoryProviderBase parent, @NotNull String name, @NotNull DeferredItem<?> icon) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(icon, (String)"icon");
        ItemLike itemLike = (ItemLike)icon;
        String string = icon.getId().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this(parent, name, itemLike, string);
    }

    public BaseEntryProvider(@Nullable CategoryProviderBase parent, @NotNull String name, @NotNull DeferredBlock<?> icon) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(icon, (String)"icon");
        ItemLike itemLike = (ItemLike)icon;
        String string = icon.getId().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this(parent, name, itemLike, string);
    }

    public BaseEntryProvider(@Nullable CategoryProviderBase parent, @NotNull String name, @NotNull ResourceLocation icon, @NotNull String entryId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)entryId, (String)"entryId");
        super(parent);
        this.name = name;
        this.entryId = entryId;
        Either either = Either.left((Object)icon);
        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(...)");
        this.icon = either;
    }

    public BaseEntryProvider(@Nullable CategoryProviderBase parent, @NotNull String name, @NotNull ItemStack icon, @NotNull String entryId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)entryId, (String)"entryId");
        super(parent);
        this.name = name;
        this.entryId = entryId;
        Either either = Either.right((Object)icon);
        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"right(...)");
        this.icon = either;
    }

    public BaseEntryProvider(@Nullable CategoryProviderBase parent, @NotNull String name, @NotNull ItemLike icon, @NotNull String entryId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)entryId, (String)"entryId");
        ItemStack itemStack = icon.asItem().getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
        this(parent, name, itemStack, entryId);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getEntryId() {
        return this.entryId;
    }

    @NotNull
    public final Either<ResourceLocation, ItemStack> getIcon() {
        return this.icon;
    }

    @NotNull
    protected String entryName() {
        return this.name;
    }

    @NotNull
    protected String entryId() {
        return this.entryId;
    }

    @NotNull
    protected Pair<Integer, Integer> entryBackground() {
        Pair pair = EntryBackground.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"DEFAULT");
        return pair;
    }

    @NotNull
    protected BookIconModel entryIcon() {
        BookIconModel bookIconModel;
        if (this.icon.left().isPresent()) {
            BookIconModel bookIconModel2 = BookIconModel.create((ResourceLocation)((ResourceLocation)this.icon.left().get()));
            Intrinsics.checkNotNull((Object)bookIconModel2);
            bookIconModel = bookIconModel2;
        } else {
            BookIconModel bookIconModel3 = BookIconModel.create((ItemStack)((ItemStack)this.icon.right().get()));
            Intrinsics.checkNotNull((Object)bookIconModel3);
            bookIconModel = bookIconModel3;
        }
        return bookIconModel;
    }

    @NotNull
    protected String entryDescription() {
        return "";
    }

    @NotNull
    public final String block(@NotNull String text, @NotNull String entryId) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)entryId, (String)"entryId");
        return "[" + text + "](entry://blocks/" + entryId + ")";
    }

    @NotNull
    public final String item(@NotNull String text, @NotNull String entryId) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)entryId, (String)"entryId");
        return "[" + text + "](entry://items/" + entryId + ")";
    }

    @NotNull
    public final BookTextPageModel textPage(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int n = this.pageIndex;
        this.pageIndex = n + 1;
        return this.textPage("page_" + n, "", text);
    }

    @NotNull
    public final BookTextPageModel textPage(@NotNull String title, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int n = this.pageIndex;
        this.pageIndex = n + 1;
        return this.textPage("page_" + n, title, text);
    }

    @NotNull
    public final BookTextPageModel textPage(@NotNull String pageId, @NotNull String title, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        BookTextPageModel page = (BookTextPageModel)this.page(pageId, () -> BaseEntryProvider.textPage$lambda$0(this));
        this.pageTitle(title);
        this.pageText(text);
        Intrinsics.checkNotNull((Object)page);
        return page;
    }

    @NotNull
    public final BookSpotlightPageModel spotlightPage(@NotNull ItemLike itemLike, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)itemLike, (String)"itemLike");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ItemStack itemStack = itemLike.asItem().getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
        return this.spotlightPage(itemStack, "", text);
    }

    @NotNull
    public final BookSpotlightPageModel spotlightPage(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Optional optional = this.icon.right();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"right(...)");
        ItemStack itemStack = (ItemStack)OptionalsKt.getOrNull((Optional)optional);
        if (itemStack == null) {
            throw new IllegalStateException("No item stack for spotlight page".toString());
        }
        ItemStack stack = itemStack;
        return this.spotlightPage(stack, "", text);
    }

    @NotNull
    public final BookSpotlightPageModel spotlightPage(@NotNull String title, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Optional optional = this.icon.right();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"right(...)");
        ItemStack itemStack = (ItemStack)OptionalsKt.getOrNull((Optional)optional);
        if (itemStack == null) {
            throw new IllegalStateException("No item stack for spotlight page".toString());
        }
        ItemStack stack = itemStack;
        return this.spotlightPage(stack, title, text);
    }

    @NotNull
    public final BookSpotlightPageModel spotlightPage(@NotNull ItemStack itemStack, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.spotlightPage(itemStack, "", text);
    }

    @NotNull
    public final BookSpotlightPageModel spotlightPage(@NotNull ItemStack itemStack, @NotNull String title, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int n = this.pageIndex;
        this.pageIndex = n + 1;
        BookSpotlightPageModel page = (BookSpotlightPageModel)this.page("page_" + n, () -> BaseEntryProvider.spotlightPage$lambda$1(this, itemStack));
        this.pageTitle(title);
        this.pageText(text);
        Intrinsics.checkNotNull((Object)page);
        return page;
    }

    @NotNull
    public final BookSpotlightPageModel spotlightPage(@NotNull Ingredient ingredient, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.spotlightPage(ingredient, "", text);
    }

    @NotNull
    public final BookSpotlightPageModel spotlightPage(@NotNull Ingredient ingredient, @NotNull String title, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int n = this.pageIndex;
        this.pageIndex = n + 1;
        BookSpotlightPageModel page = (BookSpotlightPageModel)this.page("page_" + n, () -> BaseEntryProvider.spotlightPage$lambda$2(this, ingredient));
        this.pageTitle(title);
        this.pageText(text);
        Intrinsics.checkNotNull((Object)page);
        return page;
    }

    private static final BookTextPageModel textPage$lambda$0(BaseEntryProvider this$0) {
        return BookTextPageModel.create().withTitle(this$0.context().pageTitle()).withText(this$0.context().pageText());
    }

    private static final BookSpotlightPageModel spotlightPage$lambda$1(BaseEntryProvider this$0, ItemStack $itemStack) {
        return BookSpotlightPageModel.create().withTitle(this$0.context().pageTitle()).withText(this$0.context().pageText()).withItem($itemStack);
    }

    private static final BookSpotlightPageModel spotlightPage$lambda$2(BaseEntryProvider this$0, Ingredient $ingredient) {
        return BookSpotlightPageModel.create().withTitle(this$0.context().pageTitle()).withText(this$0.context().pageText()).withItem($ingredient);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u001f\u0010\f\u001a\u00020\u00052\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\r\"\u00020\u0005\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/datagen/modonomicon/entries/BaseEntryProvider$Companion;", "", "<init>", "()V", "coloredText", "", "color", "Lnet/minecraft/ChatFormatting;", "text", "major", "minor", "bad", "paragraphs", "", "([Ljava/lang/String;)Ljava/lang/String;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String coloredText(@NotNull ChatFormatting color, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Integer n = color.getColor();
            if (n == null) {
                throw new IllegalStateException(("Invalid color " + color).toString());
            }
            int colorHexInt = n;
            String string = "%06X";
            Object[] objectArray = new Object[]{0xFFFFFF & colorHexInt};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String colorString = string2;
            return "[#](" + colorString + ")" + text + "[#]()";
        }

        @NotNull
        public final String major(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.coloredText(ChatFormatting.DARK_PURPLE, text);
        }

        @NotNull
        public final String minor(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.coloredText(ChatFormatting.DARK_AQUA, text);
        }

        @NotNull
        public final String bad(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.coloredText(ChatFormatting.RED, text);
        }

        @NotNull
        public final String paragraphs(String ... paragraphs) {
            Intrinsics.checkNotNullParameter((Object)paragraphs, (String)"paragraphs");
            return ArraysKt.joinToString$default((Object[])paragraphs, (CharSequence)" \\\n  \\\n", null, null, (int)0, null, null, (int)62, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

