/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.jumbofurnace.jumbo_furnace;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import net.commoble.jumbofurnace.JumboFurnace;
import net.commoble.jumbofurnace.JumboFurnaceUtils;
import net.commoble.jumbofurnace.jumbo_furnace.FuelItemHandler;
import net.commoble.jumbofurnace.jumbo_furnace.InputItemHandler;
import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceBlock;
import net.commoble.jumbofurnace.jumbo_furnace.MultiBlockHelper;
import net.commoble.jumbofurnace.jumbo_furnace.MultiprocessUpgradeHandler;
import net.commoble.jumbofurnace.jumbo_furnace.OutputItemHandler;
import net.commoble.jumbofurnace.recipes.InFlightRecipe;
import net.commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import net.commoble.jumbofurnace.recipes.RecipeSorter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class JumboFurnaceCoreBlockEntity
extends BlockEntity {
    public static final String INPUT = "input";
    public static final String FUEL = "fuel";
    public static final String OUTPUT = "output";
    public static final String MULTIPROCESS_UPGRADES = "multiprocess_upgrades";
    public static final String BURN_TIME = "burn_time";
    public static final String BURN_VALUE = "burn_value";
    public static final String RECIPES = "recipes";
    public static final String BACKSTOCK = "backstock";
    public static final BlockEntityTicker<JumboFurnaceCoreBlockEntity> SERVER_TICKER = (level, pos, state, core) -> core.serverTick();
    public static final Codec<List<InFlightRecipe>> INFLIGHT_RECIPES_CODEC = InFlightRecipe.CODEC.listOf();
    public static final Codec<List<ItemStack>> BACKSTOCK_CODEC = ItemStack.CODEC.listOf();
    public final InputItemHandler input = new InputItemHandler(this);
    public final ItemStackHandler fuel = new FuelItemHandler(this);
    public final OutputItemHandler output = new OutputItemHandler(this);
    public final MultiprocessUpgradeHandler multiprocessUpgradeHandler = new MultiprocessUpgradeHandler(this);
    public List<InFlightRecipe> inFlightRecipes = new ArrayList<InFlightRecipe>();
    public List<ItemStack> backstock = new ArrayList<ItemStack>();
    public IItemHandler outputSimulatorCache = null;
    public int burnTimeRemaining = 0;
    public int lastItemBurnedValue = 200;
    public boolean shouldCheckRecipes = true;

    public static JumboFurnaceCoreBlockEntity create(BlockPos pos, BlockState state) {
        return new JumboFurnaceCoreBlockEntity((BlockEntityType<? extends JumboFurnaceCoreBlockEntity>)((BlockEntityType)JumboFurnace.get().jumboFurnaceCoreBlockEntityType.get()), pos, state);
    }

    protected JumboFurnaceCoreBlockEntity(BlockEntityType<? extends JumboFurnaceCoreBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.input.deserializeNBT(registries, compound.getCompound(INPUT));
        this.fuel.deserializeNBT(registries, compound.getCompound(FUEL));
        this.output.deserializeNBT(registries, compound.getCompound(OUTPUT));
        this.multiprocessUpgradeHandler.deserializeNBT(registries, compound.getCompound(MULTIPROCESS_UPGRADES));
        this.inFlightRecipes = Lists.newArrayList((Iterable)INFLIGHT_RECIPES_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.getCompound(RECIPES)).result().orElse(List.of()));
        this.backstock = Lists.newArrayList((Iterable)BACKSTOCK_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.getCompound(BACKSTOCK)).result().orElse(List.of()));
        this.burnTimeRemaining = compound.getInt(BURN_TIME);
        this.lastItemBurnedValue = compound.getInt(BURN_VALUE);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.put(INPUT, (Tag)this.input.serializeNBT(registries));
        compound.put(FUEL, (Tag)this.fuel.serializeNBT(registries));
        compound.put(OUTPUT, (Tag)this.output.serializeNBT(registries));
        compound.put(MULTIPROCESS_UPGRADES, (Tag)this.multiprocessUpgradeHandler.serializeNBT(registries));
        INFLIGHT_RECIPES_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.inFlightRecipes).ifSuccess(tag -> compound.put(RECIPES, tag));
        BACKSTOCK_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.backstock).ifSuccess(tag -> compound.put(BACKSTOCK, tag));
        compound.putInt(BURN_TIME, this.burnTimeRemaining);
        compound.putInt(BURN_VALUE, this.lastItemBurnedValue);
    }

    public boolean isBurning() {
        return this.burnTimeRemaining > 0;
    }

    public void updateBurningBlockstates(boolean burning) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos adjacentPos = this.worldPosition.relative(direction);
            BlockState state = this.level.getBlockState(adjacentPos);
            if (!(state.getBlock() instanceof JumboFurnaceBlock)) continue;
            this.level.setBlockAndUpdate(adjacentPos, (BlockState)state.setValue((Property)JumboFurnaceBlock.LIT, (Comparable)Boolean.valueOf(burning)));
        }
    }

    public void markFuelInventoryChanged() {
        this.shouldCheckRecipes = true;
        this.setChanged();
    }

    public void markInputInventoryChanged() {
        this.shouldCheckRecipes = true;
        this.setChanged();
    }

    public void markOutputInventoryChanged() {
        this.outputSimulatorCache = null;
        this.shouldCheckRecipes = true;
        this.setChanged();
    }

    public int getMaxSimultaneousRecipes() {
        return 1 + this.multiprocessUpgradeHandler.getStackInSlot(0).getCount();
    }

    protected void serverTick() {
        boolean isBurningAfterTick;
        boolean processedAnyInputs;
        boolean wasBurningBeforeTick;
        boolean dirty = wasBurningBeforeTick = this.burnTimeRemaining > 0;
        if (this.hasHeatOrFuel()) {
            boolean processedAnyRecipes = this.processInflightRecipes();
            if (processedAnyRecipes) {
                dirty = true;
            } else if (this.burnTimeRemaining > 0) {
                --this.burnTimeRemaining;
                dirty = true;
            }
        }
        if (this.hasHeatOrFuel() && this.shouldCheckRecipes() && (processedAnyInputs = this.processInputs())) {
            dirty = true;
        }
        boolean bl = isBurningAfterTick = this.burnTimeRemaining > 0;
        if (isBurningAfterTick != wasBurningBeforeTick) {
            this.updateBurningBlockstates(isBurningAfterTick);
        }
        if (dirty) {
            this.setChanged();
            BlockPos.betweenClosedStream((BlockPos)this.getBlockPos().offset(-1, -1, -1), (BlockPos)this.getBlockPos().offset(1, 1, 1)).forEach(subPos -> {
                BlockState state = this.level.getBlockState(subPos);
                this.level.updateNeighborsAt(subPos, state.getBlock());
            });
        }
    }

    private boolean hasHeatOrFuel() {
        if (this.burnTimeRemaining > 0) {
            return true;
        }
        int slots = this.fuel.getSlots();
        for (int i = 0; i < slots; ++i) {
            if (this.fuel.getStackInSlot(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean shouldCheckRecipes() {
        if (this.shouldCheckRecipes) {
            this.shouldCheckRecipes = false;
            return true;
        }
        return false;
    }

    private boolean processInputs() {
        int freeRecipeSlots = this.getMaxSimultaneousRecipes() - this.inFlightRecipes.size();
        if (freeRecipeSlots <= 0) {
            return false;
        }
        ReferenceOpenHashSet currentInputItems = new ReferenceOpenHashSet();
        int slots = this.input.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = this.input.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            currentInputItems.add(stack.getItem());
        }
        IItemHandler outputSimulator = JumboFurnaceUtils.copyItemHandler(this.getOutputAndInFlightRecipeResults());
        ItemStack consumableFuel = ItemStack.EMPTY;
        int consumableFuelValue = 0;
        ItemStackHandler newFuelInventory = this.fuel;
        if (!this.isBurning() && (consumableFuelValue = JumboFurnaceUtils.getJumboSmeltingBurnTime(consumableFuel = JumboFurnaceCoreBlockEntity.simulateConsumeFuel((IItemHandler)(newFuelInventory = JumboFurnaceUtils.copyItemHandler((IItemHandler)this.fuel)), outputSimulator))) <= 0) {
            return false;
        }
        boolean startedAnyRecipes = false;
        SortedSet<JumboFurnaceRecipe> recipes = RecipeSorter.INSTANCE.getSortedFurnaceRecipesValidForInputs((Collection<Item>)currentInputItems, this.level.getRecipeManager());
        block1: for (JumboFurnaceRecipe recipe : recipes) {
            if (this.inFlightRecipes.size() >= this.getMaxSimultaneousRecipes()) break;
            int maxIterations = this.getMaxSimultaneousRecipes() - this.inFlightRecipes.size();
            for (int recipeIteration = 0; recipeIteration < maxIterations; ++recipeIteration) {
                IItemHandler inputSimulator = JumboFurnaceUtils.copyItemHandler((IItemHandler)this.input);
                ArrayList<ItemStack> recipeInputs = new ArrayList<ItemStack>();
                ArrayList remainders = new ArrayList();
                for (SizedIngredient sizedIngredient : recipe.ingredients()) {
                    Ingredient ingredient = sizedIngredient.ingredient();
                    int requiredPulls = sizedIngredient.count();
                    for (int pull = 0; pull < requiredPulls; ++pull) {
                        boolean foundInput = false;
                        int inputSlots = inputSimulator.getSlots();
                        for (int inputSlot = 0; inputSlot < inputSlots; ++inputSlot) {
                            if (!ingredient.test(inputSimulator.extractItem(inputSlot, 1, true))) continue;
                            ItemStack inputStack = inputSimulator.extractItem(inputSlot, 1, false);
                            recipeInputs.add(inputStack.copy());
                            foundInput = true;
                            break;
                        }
                        if (!foundInput) continue block1;
                    }
                }
                IItemHandler outputSimulatorForRecipe = JumboFurnaceUtils.copyItemHandler(outputSimulator);
                for (ItemStack stack : recipe.results()) {
                    if (ItemHandlerHelper.insertItemStacked((IItemHandler)outputSimulatorForRecipe, (ItemStack)stack.copy(), (boolean)false).isEmpty()) continue;
                    continue block1;
                }
                for (ItemStack stack : remainders) {
                    if (ItemHandlerHelper.insertItemStacked((IItemHandler)outputSimulatorForRecipe, (ItemStack)stack, (boolean)false).isEmpty()) continue;
                    continue block1;
                }
                outputSimulator = outputSimulatorForRecipe;
                JumboFurnaceUtils.copyItemHandlerTo(inputSimulator, (IItemHandlerModifiable)this.input);
                this.inFlightRecipes.add(new InFlightRecipe(recipe, recipeInputs));
                for (ItemStack stack : remainders) {
                    this.addToOutputOrBackstock(stack);
                }
                startedAnyRecipes = true;
            }
        }
        if (consumableFuelValue > 0 && startedAnyRecipes) {
            this.burnTimeRemaining += consumableFuelValue;
            this.lastItemBurnedValue = consumableFuelValue;
            JumboFurnaceUtils.copyItemHandlerTo((IItemHandler)newFuelInventory, (IItemHandlerModifiable)this.fuel);
            ItemStack fuelRemainder = consumableFuel.getCraftingRemainingItem();
            if (!fuelRemainder.isEmpty()) {
                this.addToFuelOrOutputOrBackstock(fuelRemainder.copy());
            }
        }
        if (startedAnyRecipes && this.outputSimulatorCache != null) {
            this.outputSimulatorCache = outputSimulator;
        }
        return startedAnyRecipes;
    }

    private boolean processInflightRecipes() {
        if (this.inFlightRecipes.isEmpty()) {
            return false;
        }
        boolean anyFuelLeftToCheck = true;
        boolean progressedAnyRecipes = false;
        ArrayList<InFlightRecipe> remainingRecipes = new ArrayList<InFlightRecipe>();
        for (InFlightRecipe recipe : this.inFlightRecipes) {
            if (anyFuelLeftToCheck) {
                if (this.tryHaveHeat()) {
                    progressedAnyRecipes = true;
                    --this.burnTimeRemaining;
                    boolean completed = recipe.incrementProgress();
                    if (completed) {
                        for (ItemStack stack : recipe.recipe().results()) {
                            this.addToOutputOrBackstock(stack.copy());
                        }
                        this.output.addExperience(recipe.recipe().experience());
                        this.shouldCheckRecipes = true;
                        continue;
                    }
                    remainingRecipes.add(recipe);
                    continue;
                }
                anyFuelLeftToCheck = false;
                remainingRecipes.add(recipe);
                continue;
            }
            remainingRecipes.add(recipe);
        }
        this.inFlightRecipes = remainingRecipes;
        return progressedAnyRecipes;
    }

    private boolean tryHaveHeat() {
        return this.burnTimeRemaining > 0 || this.tryConsumeFuel(this.getOutputAndInFlightRecipeResults());
    }

    private boolean tryConsumeFuel(IItemHandler outputSimulator) {
        int slots = this.fuel.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack remainder;
            ItemStack stackInSlot = this.fuel.extractItem(slot, 1, true);
            int burnTime = JumboFurnaceUtils.getJumboSmeltingBurnTime(stackInSlot);
            if (burnTime <= 0 || !(remainder = stackInSlot.getCraftingRemainingItem().copy()).isEmpty() && (JumboFurnaceUtils.getJumboSmeltingBurnTime(remainder) <= 0 || !ItemHandlerHelper.insertItemStacked((IItemHandler)this.fuel, (ItemStack)remainder, (boolean)true).isEmpty()) && !ItemHandlerHelper.insertItemStacked((IItemHandler)outputSimulator, (ItemStack)remainder, (boolean)true).isEmpty()) continue;
            this.fuel.extractItem(slot, 1, false);
            this.burnTimeRemaining += burnTime;
            this.lastItemBurnedValue = burnTime;
            this.addToFuelOrOutputOrBackstock(remainder);
            return true;
        }
        return false;
    }

    private static ItemStack simulateConsumeFuel(IItemHandler fuelInventory, IItemHandler outputInventory) {
        int slots = fuelInventory.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stackInSlot = fuelInventory.extractItem(slot, 1, false);
            if (stackInSlot.isEmpty()) continue;
            int burnTime = JumboFurnaceUtils.getJumboSmeltingBurnTime(stackInSlot);
            if (burnTime > 0) {
                ItemStack remainder = stackInSlot.getCraftingRemainingItem();
                if (remainder.isEmpty()) {
                    return stackInSlot.copy();
                }
                if (JumboFurnaceUtils.getJumboSmeltingBurnTime(remainder) > 0 && (remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)fuelInventory, (ItemStack)remainder.copy(), (boolean)true)).isEmpty()) {
                    return stackInSlot.copy();
                }
                if (ItemHandlerHelper.insertItemStacked((IItemHandler)outputInventory, (ItemStack)remainder.copy(), (boolean)false).isEmpty()) {
                    return stackInSlot.copy();
                }
            }
            fuelInventory.insertItem(slot, stackInSlot, false);
        }
        return ItemStack.EMPTY;
    }

    private IItemHandler getOutputAndInFlightRecipeResults() {
        if (this.outputSimulatorCache == null) {
            IItemHandler outputSimulator = JumboFurnaceUtils.copyItemHandler((IItemHandler)this.output);
            for (InFlightRecipe recipe : this.inFlightRecipes) {
                for (ItemStack stack : recipe.recipe().results()) {
                    ItemHandlerHelper.insertItemStacked((IItemHandler)outputSimulator, (ItemStack)stack.copy(), (boolean)false);
                }
            }
            this.outputSimulatorCache = outputSimulator;
        }
        return this.outputSimulatorCache;
    }

    public void setChanged() {
        super.setChanged();
        MultiBlockHelper.get3x3CubeAround(this.worldPosition).filter(exteriorPos -> !exteriorPos.equals((Object)this.worldPosition)).forEach(exteriorPos -> this.level.updateNeighbourForOutputSignal(exteriorPos, this.getBlockState().getBlock()));
    }

    private void addToFuelOrOutputOrBackstock(ItemStack stack) {
        if (JumboFurnaceUtils.getJumboSmeltingBurnTime(stack) > 0) {
            stack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.fuel, (ItemStack)stack, (boolean)false);
        }
        if (!stack.isEmpty()) {
            this.addToOutputOrBackstock(stack);
        }
    }

    private void addToOutputOrBackstock(ItemStack stack) {
        ItemStack extraRemainder = this.output.insertCraftResult(stack, false);
        if (!extraRemainder.isEmpty()) {
            this.backstock.add(extraRemainder);
            this.outputSimulatorCache = null;
            this.shouldCheckRecipes = true;
        }
    }
}

