/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items;

import com.direwolf20.justdirethings.common.blocks.resources.CoalBlock_T1;
import com.direwolf20.justdirethings.common.containers.FuelCanisterContainer;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.resources.Coal_T1;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.util.MagicHelpers;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FuelCanister
extends Item {
    public FuelCanister() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Level level = context.level();
        if (level == null) {
            return;
        }
        boolean sneakPressed = Screen.hasShiftDown();
        if (sneakPressed) {
            tooltip.add((Component)Component.translatable((String)"justdirethings.fuelcanisteramt", (Object[])new Object[]{MagicHelpers.formatted(FuelCanister.getFuelLevel(stack))}).withStyle(ChatFormatting.AQUA));
        } else {
            tooltip.add((Component)Component.translatable((String)"justdirethings.fuelcanisteritemsamt", (Object[])new Object[]{MagicHelpers.formatted((float)FuelCanister.getFuelLevel(stack) / 200.0f)}).withStyle(ChatFormatting.AQUA));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new FuelCanisterContainer(windowId, playerInventory, player, itemstack), (Component)Component.translatable((String)"")), buf -> ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)itemstack));
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public int getBurnTime(ItemStack stack, @Nullable RecipeType<?> recipeType) {
        return FuelCanister.getFuelLevel(stack) >= (Integer)Config.FUEL_CANISTER_MINIMUM_TICKS_CONSUMED.get() ? (Integer)Config.FUEL_CANISTER_MINIMUM_TICKS_CONSUMED.get() : 0;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        ItemStack copy = stack.copy();
        FuelCanister.decrementFuel(copy);
        return copy;
    }

    public static int getFuelLevel(ItemStack stack) {
        return (Integer)stack.getOrDefault(JustDireDataComponents.FUELCANISTER_FUELLEVEL, (Object)0);
    }

    public static void setFuelLevel(ItemStack stack, int fuelLevel) {
        stack.set(JustDireDataComponents.FUELCANISTER_FUELLEVEL, (Object)fuelLevel);
    }

    public static double getBurnSpeed(ItemStack stack) {
        return (Double)stack.getOrDefault(JustDireDataComponents.FUELCANISTER_BURNSPEED, (Object)1.0);
    }

    public static int getBurnSpeedMultiplier(ItemStack stack) {
        double burnSpeed = FuelCanister.getBurnSpeed(stack);
        return (int)Math.round(burnSpeed);
    }

    public static void setBurnSpeed(ItemStack stack, double burnSpeed) {
        stack.set(JustDireDataComponents.FUELCANISTER_BURNSPEED, (Object)burnSpeed);
    }

    public static void decrementFuel(ItemStack stack) {
        int currentFuel = FuelCanister.getFuelLevel(stack);
        if (currentFuel >= (Integer)Config.FUEL_CANISTER_MINIMUM_TICKS_CONSUMED.get()) {
            currentFuel -= ((Integer)Config.FUEL_CANISTER_MINIMUM_TICKS_CONSUMED.get()).intValue();
        }
        FuelCanister.setFuelLevel(stack, currentFuel);
    }

    public static double calculateBurnSpeed(int currentFuelLevel, double currentBurnSpeedMultiplier, int newFuelLevel, double newFuelMultiplier) {
        double totalFuel = currentFuelLevel + newFuelLevel;
        double newBurnSpeedMultiplier = ((double)currentFuelLevel * currentBurnSpeedMultiplier + (double)newFuelLevel * newFuelMultiplier) / totalFuel;
        return newBurnSpeedMultiplier;
    }

    public static void incrementFuel(ItemStack stack, ItemStack fuelStack) {
        int currentFuel = FuelCanister.getFuelLevel(stack);
        int fuelPerPiece = fuelStack.getBurnTime(RecipeType.SMELTING);
        if (fuelPerPiece == 0) {
            return;
        }
        double currentBurnSpeedMultiplier = FuelCanister.getBurnSpeed(stack);
        int fuelMultiplier = 1;
        Item item = fuelStack.getItem();
        if (item instanceof Coal_T1) {
            Coal_T1 direCoal = (Coal_T1)item;
            fuelMultiplier = direCoal.getBurnSpeedMultiplier();
        } else {
            BlockItem blockItem;
            item = fuelStack.getItem();
            if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof CoalBlock_T1) {
                CoalBlock_T1 coalBlock = (CoalBlock_T1)item;
                fuelMultiplier = coalBlock.getBurnSpeedMultiplier();
            }
        }
        int totalNewFuel = 0;
        while (currentFuel + totalNewFuel + fuelPerPiece <= (Integer)Config.FUEL_CANISTER_MAXIMUM_FUEL.get() && !fuelStack.isEmpty()) {
            totalNewFuel += fuelPerPiece;
            fuelStack.shrink(1);
        }
        if (totalNewFuel > 0) {
            currentBurnSpeedMultiplier = FuelCanister.calculateBurnSpeed(currentFuel, currentBurnSpeedMultiplier, totalNewFuel, fuelMultiplier);
        }
        FuelCanister.setFuelLevel(stack, currentFuel + totalNewFuel);
        FuelCanister.setBurnSpeed(stack, currentBurnSpeedMultiplier);
    }
}

