/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.callback;

import dev.latvian.mods.kubejs.block.callback.BlockStateModifyCallback;
import dev.latvian.mods.kubejs.level.LevelBlock;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BlockStateModifyPlacementCallback
extends BlockStateModifyCallback {
    public final BlockPlaceContext context;
    public final Block minecraftBlock;
    public LevelBlock block;

    public BlockStateModifyPlacementCallback(BlockPlaceContext context, Block block) {
        super(BlockStateModifyPlacementCallback.getBlockStateToModify(context, block));
        this.context = context;
        this.minecraftBlock = block;
        this.block = context.getLevel().kjs$getBlock(context.getClickedPos());
    }

    private static BlockState getBlockStateToModify(BlockPlaceContext context, Block block) {
        BlockState previous = context.getLevel().getBlockState(context.getClickedPos());
        if (previous.getBlock() == block) {
            return previous;
        }
        return block.defaultBlockState();
    }

    @Info(value="Gets the clicked position in world")
    public BlockPos getClickedPos() {
        return this.context.getClickedPos();
    }

    @Info(value="Gets the clicked block")
    public LevelBlock getClickedBlock() {
        return this.getLevel().kjs$getBlock(this.getClickedPos());
    }

    @Info(value="Returns if the block being placed thinks it can be placed here. This is used for replacement checks, like placing blocks in water or tall grass")
    public boolean canPlace() {
        return this.context.canPlace();
    }

    @Info(value="Returns if the block being placed is replacing the block clicked")
    public boolean replacingClickedOnBlock() {
        return this.context.replacingClickedOnBlock();
    }

    @Info(value="Gets the direction closes to where the player is currently looking")
    public Direction getNearestLookingDirection() {
        return this.context.getNearestLookingDirection();
    }

    @Info(value="Gets the vertical direction (UP/DOWN) closest to where the player is currently looking")
    public Direction getNearestLookingVerticalDirection() {
        return this.context.getNearestLookingVerticalDirection();
    }

    @Info(value="Gets an array of all directions, ordered by which the player is looking closest to")
    public Direction[] getNearestLookingDirections() {
        return this.context.getNearestLookingDirections();
    }

    @Info(value="Gets the facing direction of the clicked block face")
    public Direction getClickedFace() {
        return this.context.getClickedFace();
    }

    @Info(value="Gets the position in the block-space of where it was clicked")
    public Vec3 getClickLocation() {
        return this.context.getClickLocation();
    }

    @Info(value="Returns if the hit posiiton in the block-space is inside the 1x1x1 cube of the block")
    public boolean isInside() {
        return this.context.isInside();
    }

    @Info(value="Gets the item being placed")
    public ItemStack getItem() {
        return this.context.getItemInHand();
    }

    @Info(value="Gets the player placing the block, if available")
    @Nullable
    public Player getPlayer() {
        return this.context.getPlayer();
    }

    @Info(value="Gets the hand that is placing the block")
    public InteractionHand getHand() {
        return this.context.getHand();
    }

    @Info(value="Gets the level")
    public Level getLevel() {
        return this.context.getLevel();
    }

    @Info(value="Gets the nearest horizontal direction to where the player is looking. NORTH if there is no player")
    public Direction getHorizontalDirection() {
        return this.context.getHorizontalDirection();
    }

    @Info(value="Returns if the player is using the 'secondary' function of this item. Basically checks if they are holding shift")
    public boolean isSecondaryUseActive() {
        return this.context.isSecondaryUseActive();
    }

    @Info(value="Get the horizontal rotation of the player")
    public float getRotation() {
        return this.context.getRotation();
    }

    @Info(value="Gets the FluidSate at the clicked position")
    public FluidState getFluidStateAtClickedPos() {
        return this.context.getLevel().getFluidState(this.context.getClickedPos());
    }

    @Info(value="Checks if the position clicked has a specified fluid there")
    public boolean isClickedPosIn(Fluid fluid) {
        return this.getFluidStateAtClickedPos().is(fluid);
    }

    @Info(value="Set if this block is waterlogged or not")
    public BlockStateModifyPlacementCallback waterlogged(boolean waterlogged) {
        this.setValue(BlockStateProperties.WATERLOGGED, waterlogged);
        return this;
    }

    @Info(value="Set this block as waterlogged if it is in water")
    public BlockStateModifyPlacementCallback waterlogged() {
        return this.waterlogged(this.isInWater());
    }

    @Info(value="Checks if this block is in water")
    public boolean isInWater() {
        return this.getFluidStateAtClickedPos().getType() == Fluids.WATER;
    }

    @Info(value="Checks if the block currently occupying the position this is being placed in is the same block type.\nUsed for things like candles, where multiple can be in the same block-space.\n")
    public boolean isReplacingSelf() {
        return this.getLevel().getBlockState(this.getClickedPos()).getBlock() == this.minecraftBlock;
    }
}

