/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items.cards;

import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.setup.LaserIODataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CardItem
extends BaseCard {
    public CardItem() {
        this.CARDTYPE = BaseCard.CardType.ITEM;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CardItemContainer(windowId, playerInventory, player, itemstack), (Component)Component.translatable((String)"")), buf -> {
            ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)itemstack);
            buf.writeByte(-1);
        });
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public static byte setItemExtractAmt(ItemStack card, byte itemextractamt) {
        if (itemextractamt == 1) {
            card.remove(LaserIODataComponents.ITEM_CARD_EXTRACT_AMT);
        } else {
            card.set(LaserIODataComponents.ITEM_CARD_EXTRACT_AMT, (Object)itemextractamt);
        }
        return itemextractamt;
    }

    public static byte getItemExtractAmt(ItemStack card) {
        return ((Number)card.getOrDefault(LaserIODataComponents.ITEM_CARD_EXTRACT_AMT, (Object)1)).byteValue();
    }
}

