/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.mixin.client;

import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL31;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.lodestar.lodestone.systems.rendering.IVertexBuffer;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderSystem;

@Mixin(value={VertexBuffer.class})
public abstract class VertexBufferMixin
implements IVertexBuffer {
    @Unique
    private Map<Integer, Integer> extraVBOs = new HashMap<Integer, Integer>();
    @Shadow
    private VertexFormat.Mode mode;
    @Shadow
    private VertexFormat format;
    @Shadow
    private int indexCount;

    @Override
    public void drawInstanced(int instances) {
        LodestoneRenderSystem.wrap(() -> GL31.glDrawElementsInstanced((int)this.mode.asGLMode, (int)this.indexCount, (int)this.getIndexType().asGLType, (long)0L, (int)instances));
    }

    @Override
    public void drawWithShaderInstanced(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, ShaderInstance shader, int instances) {
        LodestoneRenderSystem.wrap(() -> {
            shader.setDefaultUniforms(this.mode, modelViewMatrix, projectionMatrix, Minecraft.getInstance().getWindow());
            shader.apply();
            this.drawInstanced(instances);
            shader.clear();
        });
    }

    @Override
    public void addAttributeVBO(int binding, FloatBuffer buffer, VertexBuffer.Usage usage, Consumer<Integer> setup) {
        this.bind();
        int vbo = this.extraVBOs.computeIfAbsent(binding, v -> GL31.glGenBuffers());
        GL31.glBindBuffer((int)34962, (int)vbo);
        GL31.glBufferData((int)34962, (FloatBuffer)buffer, (int)usage.id);
        setup.accept(binding);
    }

    @Inject(method={"close"}, at={@At(value="HEAD")})
    public void close(CallbackInfo ci) {
        this.extraVBOs.forEach((binding, vbo) -> GL31.glDeleteBuffers((int)vbo));
    }

    @Shadow
    public abstract VertexFormat.IndexType getIndexType();

    @Shadow
    public abstract void bind();
}

