/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class LodestoneItemProperties
extends Item.Properties {
    public static final Map<ResourceKey<CreativeModeTab>, List<ResourceLocation>> TAB_SORTING = new HashMap<ResourceKey<CreativeModeTab>, List<ResourceLocation>>();
    public final ResourceKey<CreativeModeTab> tab;

    public LodestoneItemProperties(DeferredHolder<CreativeModeTab, CreativeModeTab> tab) {
        this((ResourceKey<CreativeModeTab>)tab.getKey());
    }

    public LodestoneItemProperties(ResourceKey<CreativeModeTab> tab) {
        this.tab = tab;
    }

    public LodestoneItemProperties() {
        this.tab = null;
    }

    public static Item.Properties mergeAttributes(Item.Properties properties, ItemAttributeModifiers attributes) {
        DataComponentMap.Builder components = properties.components;
        if (components != null && components.build().has(DataComponents.ATTRIBUTE_MODIFIERS)) {
            ItemAttributeModifiers existing = (ItemAttributeModifiers)components.build().get(DataComponents.ATTRIBUTE_MODIFIERS);
            ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
            if (existing != null) {
                for (ItemAttributeModifiers.Entry entry : existing.modifiers()) {
                    builder.add(entry.attribute(), entry.modifier(), entry.slot());
                }
            }
            for (ItemAttributeModifiers.Entry entry : attributes.modifiers()) {
                builder.add(entry.attribute(), entry.modifier(), entry.slot());
            }
            return properties.attributes(builder.build());
        }
        return properties.attributes(attributes);
    }

    public LodestoneItemProperties mergeAttributes(ItemAttributeModifiers attributes) {
        if (this.components != null && this.components.build().has(DataComponents.ATTRIBUTE_MODIFIERS)) {
            ItemAttributeModifiers existing = (ItemAttributeModifiers)this.components.build().get(DataComponents.ATTRIBUTE_MODIFIERS);
            ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
            for (ItemAttributeModifiers.Entry entry : existing.modifiers()) {
                builder.add(entry.attribute(), entry.modifier(), entry.slot());
            }
            for (ItemAttributeModifiers.Entry entry : attributes.modifiers()) {
                builder.add(entry.attribute(), entry.modifier(), entry.slot());
            }
            return this.attributes(builder.build());
        }
        return this.attributes(attributes);
    }

    public LodestoneItemProperties food(FoodProperties food) {
        return (LodestoneItemProperties)super.food(food);
    }

    public LodestoneItemProperties stacksTo(int maxStackSize) {
        return (LodestoneItemProperties)super.stacksTo(maxStackSize);
    }

    public LodestoneItemProperties durability(int maxDamage) {
        return (LodestoneItemProperties)super.durability(maxDamage);
    }

    public LodestoneItemProperties craftRemainder(Item craftingRemainingItem) {
        return (LodestoneItemProperties)super.craftRemainder(craftingRemainingItem);
    }

    public LodestoneItemProperties rarity(Rarity rarity) {
        return (LodestoneItemProperties)super.rarity(rarity);
    }

    public LodestoneItemProperties fireResistant() {
        return (LodestoneItemProperties)super.fireResistant();
    }

    public LodestoneItemProperties jukeboxPlayable(ResourceKey<JukeboxSong> song) {
        return (LodestoneItemProperties)super.jukeboxPlayable(song);
    }

    public LodestoneItemProperties setNoRepair() {
        return (LodestoneItemProperties)super.setNoRepair();
    }

    public LodestoneItemProperties requiredFeatures(FeatureFlag ... requiredFeatures) {
        return (LodestoneItemProperties)super.requiredFeatures(requiredFeatures);
    }

    public <T> LodestoneItemProperties component(DataComponentType<T> component, T value) {
        return (LodestoneItemProperties)super.component(component, value);
    }

    public LodestoneItemProperties attributes(ItemAttributeModifiers attributes) {
        return (LodestoneItemProperties)super.attributes(attributes);
    }

    public static void addToTabSorting(ResourceLocation itemId, Item.Properties properties) {
        if (properties instanceof LodestoneItemProperties) {
            LodestoneItemProperties lodestoneItemProperties = (LodestoneItemProperties)properties;
            if (lodestoneItemProperties.tab == null) {
                return;
            }
            TAB_SORTING.computeIfAbsent(lodestoneItemProperties.tab, key -> new ArrayList()).add(itemId);
        }
    }

    public static void populateItemGroups(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tabKey = event.getTabKey();
        if (TAB_SORTING.containsKey(tabKey)) {
            TAB_SORTING.get(tabKey).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).filter(s -> !event.getParentEntries().contains((Object)s.getDefaultInstance())).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
        }
    }
}

