/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.model.geo.data;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.renderer.RenderType;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import team.lodestar.lodestone.systems.model.geo.data.GeoCube;

public class GeoBone {
    private Vector3f position;
    private float xRot;
    private float yRot;
    private float zRot;
    private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    private final List<GeoCube> cubes;
    private final Map<String, GeoBone> children;
    private final String parent;

    public GeoBone(List<GeoCube> cubes, Map<String, GeoBone> children, String parent) {
        this.cubes = cubes;
        this.children = children;
        this.parent = parent;
    }

    public void copyFrom(GeoBone geoBone) {
        this.scale.x = geoBone.scale.x;
        this.scale.y = geoBone.scale.y;
        this.scale.z = geoBone.scale.z;
        this.xRot = geoBone.xRot;
        this.yRot = geoBone.yRot;
        this.zRot = geoBone.zRot;
        this.position.x = geoBone.position.x;
        this.position.y = geoBone.position.y;
        this.position.z = geoBone.position.z;
    }

    public boolean hasChild(String name) {
        return this.children.containsKey(name);
    }

    public GeoBone getChild(String name) {
        GeoBone bone = this.children.get(name);
        if (bone == null) {
            throw new NoSuchElementException("Can't find bone " + name);
        }
        return bone;
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public void setPosition(float x, float y, float z) {
        this.position.set(x, y, z);
    }

    public void setRotation(float xDeg, float yDeg, float zDeg) {
        this.xRot = (float)Math.toRadians(xDeg);
        this.yRot = (float)Math.toRadians(yDeg);
        this.zRot = (float)Math.toRadians(zDeg);
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public float getxRot() {
        return this.xRot;
    }

    public float getyRot() {
        return this.yRot;
    }

    public float getzRot() {
        return this.zRot;
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public List<GeoCube> getCubes() {
        return this.cubes;
    }

    public Map<String, GeoBone> getChildren() {
        return this.children;
    }

    public String getParent() {
        return this.parent;
    }

    public void addChild(String name, GeoBone bone) {
        this.children.put(name, bone);
    }

    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, RenderType renderType) {
        if (!this.cubes.isEmpty() || !this.children.isEmpty()) {
            poseStack.pushPose();
            this.translateAndRotate(poseStack);
            for (GeoCube cube : this.cubes) {
                cube.render(poseStack, vertexConsumer, renderType);
            }
            for (GeoBone child : this.children.values()) {
                child.render(poseStack, vertexConsumer, renderType);
            }
            poseStack.popPose();
        }
    }

    public void translateAndRotate(PoseStack poseStack) {
        float px = this.position.x / 16.0f;
        float py = this.position.y / 16.0f;
        float pz = this.position.z / 16.0f;
        poseStack.translate(px, py, pz);
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            poseStack.mulPose(new Quaternionf().rotationZYX(-this.zRot, this.yRot, -this.xRot));
        }
        poseStack.translate(-px, -py, -pz);
        if (this.scale.x != 1.0f || this.scale.y != 1.0f || this.scale.z != 1.0f) {
            poseStack.scale(this.scale.x, this.scale.y, this.scale.z);
        }
    }
}

