/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.screen.base;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.particle.screen.base.ScreenParticle;

@OnlyIn(value=Dist.CLIENT)
public abstract class QuadScreenParticle
extends ScreenParticle {
    protected float quadSize;

    protected QuadScreenParticle(ClientLevel pLevel, double pX, double pY) {
        super(pLevel, pX, pY);
        this.quadSize = 0.1f * (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f;
    }

    protected QuadScreenParticle(ClientLevel pLevel, double pX, double pY, double pXSpeed, double pYSpeed) {
        super(pLevel, pX, pY, pXSpeed, pYSpeed);
        this.quadSize = 0.1f * (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f;
    }

    @Override
    public void render(BufferBuilder bufferBuilder, @Nullable PoseStack poseStack) {
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        float width = this.getQuadSize(partialTicks) * 10.0f;
        float length = this.getQuadLength(partialTicks) * 10.0f;
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        Vector3f[] vectors = this.getVertices(partialTicks, width, length);
        float quadZ = this.getQuadZPosition();
        if (poseStack != null) {
            PoseStack.Pose pose = poseStack.last();
            bufferBuilder.addVertex(pose, vectors[0].x(), vectors[0].y(), quadZ).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
            bufferBuilder.addVertex(pose, vectors[1].x(), vectors[1].y(), quadZ).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
            bufferBuilder.addVertex(pose, vectors[2].x(), vectors[2].y(), quadZ).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
            bufferBuilder.addVertex(pose, vectors[3].x(), vectors[3].y(), quadZ).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
        } else {
            bufferBuilder.addVertex(vectors[0].x(), vectors[0].y(), quadZ).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
            bufferBuilder.addVertex(vectors[1].x(), vectors[1].y(), quadZ).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
            bufferBuilder.addVertex(vectors[2].x(), vectors[2].y(), quadZ).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
            bufferBuilder.addVertex(vectors[3].x(), vectors[3].y(), quadZ).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
        }
    }

    private Vector3f @NotNull [] getVertices(float partialTicks, float width, float length) {
        float roll = Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll);
        Vector3f[] vectors = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        Quaternionf rotation = new Quaternionf(new AxisAngle4f(roll, (Vector3fc)VecHelper.Vector3fHelper.ZP));
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = vectors[i];
            vector3f.rotate((Quaternionfc)rotation);
            vector3f.mul(width, length, 1.0f);
            vector3f.add((float)this.x, (float)this.y, 0.0f);
        }
        return vectors;
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize;
    }

    public float getQuadLength(float partialTicks) {
        return this.quadSize;
    }

    public float getQuadZPosition() {
        return 1000.0f;
    }

    protected abstract float getU0();

    protected abstract float getU1();

    protected abstract float getV0();

    protected abstract float getV1();
}

