/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.screenshake;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.easing.Easing;

public class ScreenshakeInstance {
    public static final Codec<ScreenshakeInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("duration").forGetter(data -> data.duration), (App)Codec.FLOAT.fieldOf("startingStrength").forGetter(data -> Float.valueOf(data.startingStrength)), (App)Codec.FLOAT.fieldOf("middleStrength").forGetter(data -> Float.valueOf(data.middleStrength)), (App)Codec.FLOAT.fieldOf("endingStrength").forGetter(data -> Float.valueOf(data.endingStrength)), (App)Easing.CODEC.fieldOf("startingCurve").forGetter(data -> data.startingCurve), (App)Easing.CODEC.fieldOf("endingCurve").forGetter(data -> data.endingCurve), (App)Codec.FLOAT.fieldOf("coefficient").forGetter(data -> Float.valueOf(data.coefficient)), (App)ScreenshakePositionData.CODEC.optionalFieldOf("positionData").forGetter(data -> Optional.of(data.positionData))).apply((Applicative)instance, ScreenshakeInstance::new));
    public static StreamCodec<ByteBuf, ScreenshakeInstance> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    protected final int duration;
    protected final float startingStrength;
    protected final float middleStrength;
    protected final float endingStrength;
    protected final Easing startingCurve;
    protected final Easing endingCurve;
    protected final float coefficient;
    protected final ScreenshakePositionData positionData;
    protected int progress;
    protected boolean expired;

    public ScreenshakeInstance(int duration, float startingStrength, float middleStrength, float endingStrength, Easing startingCurve, Easing endingCurve, float coefficient, Optional<ScreenshakePositionData> positionData) {
        this.duration = duration;
        this.startingStrength = startingStrength;
        this.middleStrength = middleStrength;
        this.endingStrength = endingStrength;
        this.startingCurve = startingCurve;
        this.endingCurve = endingCurve;
        this.coefficient = coefficient;
        this.positionData = positionData.orElse(null);
    }

    public void tick() {
        if (this.progress < this.duration) {
            ++this.progress;
            if (this.progress == this.duration) {
                this.expired = true;
            }
        }
    }

    public float getStrength(Camera camera) {
        float falloffDistance;
        Vec3 center;
        float strength = this.getStrength();
        if (this.positionData == null) {
            return strength;
        }
        Vec3 cameraPos = camera.getPosition();
        float distance = (float)cameraPos.distanceTo(center = this.positionData.center());
        if (distance > (falloffDistance = this.positionData.falloffDistance()) || falloffDistance == 0.0f) {
            return 0.0f;
        }
        float falloff = 1.0f - this.positionData.falloffCurve().clamped(distance / falloffDistance, 0.0f, 1.0f);
        return strength * falloff;
    }

    protected float getStrength() {
        if (this.expired) {
            return 0.0f;
        }
        float percentage = (float)this.progress * this.coefficient / (float)this.duration;
        if (this.isTrinary()) {
            if (percentage >= 0.5f) {
                float delta = this.endingCurve.clamped((percentage - 0.5f) * 2.0f, 0.0f, 1.0f);
                return Mth.lerp((float)delta, (float)this.middleStrength, (float)this.endingStrength);
            }
            float delta = this.startingCurve.clamped(percentage * 2.0f, 0.0f, 1.0f);
            return Mth.lerp((float)delta, (float)this.startingStrength, (float)this.middleStrength);
        }
        float delta = this.startingCurve.clamped(percentage, 0.0f, 1.0f);
        return Mth.lerp((float)delta, (float)this.startingStrength, (float)this.middleStrength);
    }

    public boolean isExpired() {
        return this.expired;
    }

    public boolean isTrinary() {
        return this.endingStrength != this.middleStrength;
    }

    public record ScreenshakePositionData(Vec3 center, float falloffDistance, Easing falloffCurve) {
        public static final Codec<ScreenshakePositionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3.CODEC.fieldOf("center").forGetter(data -> data.center), (App)Codec.FLOAT.fieldOf("falloffDistance").forGetter(data -> Float.valueOf(data.falloffDistance)), (App)Easing.CODEC.fieldOf("falloffCurve").forGetter(data -> data.falloffCurve)).apply((Applicative)instance, ScreenshakePositionData::new));
        public static StreamCodec<ByteBuf, ScreenshakePositionData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    }
}

