/*
 * Decompiled with CFR 0.152.
 */
package net.sirgrantd.magic_coins.gui.handlers.conversor;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.sirgrantd.magic_coins.MagicCoinsMod;
import net.sirgrantd.magic_coins.api.MagicCoinsApi;
import net.sirgrantd.magic_coins.init.ItemsInit;
import net.sirgrantd.magic_coins.utils.Utils;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record ConvertGoldForCrystal(int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ConvertGoldForCrystal> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"gold_for_crystal_button"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ConvertGoldForCrystal> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new ConvertGoldForCrystal(buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<ConvertGoldForCrystal> type() {
        return TYPE;
    }

    public static void handleData(ConvertGoldForCrystal message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int x = message.x;
                int y = message.y;
                int z = message.z;
                ConvertGoldForCrystal.handleButtonAction(entity, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player player, int x, int y, int z) {
        IItemHandlerModifiable itemHandlerModifiable;
        int goldCoins;
        if (player == null) {
            return;
        }
        Object object = player.getCapability(Capabilities.ItemHandler.ENTITY, null);
        if (object instanceof IItemHandlerModifiable && (goldCoins = Utils.countItems((IItemHandler)(itemHandlerModifiable = (IItemHandlerModifiable)object), (Item)ItemsInit.GOLD_COIN.get()) * MagicCoinsApi.getValueGoldCoins()) >= MagicCoinsApi.getValueCrystalCoins()) {
            int crystalCoins = goldCoins / MagicCoinsApi.getValueCrystalCoins();
            int remainingGoldCoins = goldCoins % MagicCoinsApi.getValueCrystalCoins();
            Utils.removeItemsFromInventory(player, (Item)ItemsInit.GOLD_COIN.get(), goldCoins / MagicCoinsApi.getValueGoldCoins() - remainingGoldCoins / MagicCoinsApi.getValueGoldCoins());
            ItemStack crystalCoin = new ItemStack((ItemLike)ItemsInit.CRYSTAL_COIN.get(), crystalCoins);
            if (!player.getInventory().add(crystalCoin)) {
                player.drop(crystalCoin, false);
            }
        }
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        MagicCoinsMod.addNetworkMessage(TYPE, STREAM_CODEC, ConvertGoldForCrystal::handleData);
    }
}

