/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.common.entity.FloatingItemEntity;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.EasingHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;

public class FloatingItemEntityRenderer
extends EntityRenderer<FloatingItemEntity> {
    public final ItemRenderer itemRenderer;

    public FloatingItemEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
        this.shadowRadius = 0.0f;
        this.shadowStrength = 0.0f;
    }

    public void render(FloatingItemEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        SpiritArcanaType spiritType = entity.getSpiritType();
        LodestoneRenderTypeBuilder trail = LodestoneRenderTypes.ADDITIVE_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
        LodestoneRenderTypeBuilder longTrail = LodestoneRenderTypes.ADDITIVE_ROUNDED_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
        SpiritBasedWorldVFXBuilder builder = SpiritBasedWorldVFXBuilder.create(spiritType);
        float effectScalar = entity.getVisualEffectScalar();
        RenderUtils.renderEntityTrail(poseStack, builder.setRenderType(trail), entity.trail, (Entity)entity, spiritType.getPrimaryColor(), spiritType.getSecondaryColor(), effectScalar, partialTicks);
        RenderUtils.renderEntityTrail(poseStack, builder.setRenderType(longTrail), entity.longTrail, (Entity)entity, spiritType.getSecondaryColor(), spiritType.getPrimaryColor(), effectScalar * 0.6f, effectScalar * 0.2f, partialTicks);
        FloatingItemEntityRenderer.renderSpiritEntity(entity, this.itemRenderer, partialTicks, poseStack, bufferIn, packedLightIn);
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public static void renderSpiritEntity(FloatingItemEntity entity, ItemRenderer itemRenderer, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        Level level = entity.level();
        ItemStack stack = entity.getItem();
        BakedModel model = itemRenderer.getModel(stack, level, null, entity.getItem().getCount());
        float yOffset = entity.getYOffset(partialTicks);
        float scale = model.getTransforms().getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y();
        float rotation = entity.getRotation(partialTicks);
        poseStack.pushPose();
        poseStack.translate(0.0, (double)yOffset, 0.0);
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, entity.getSpiritType(), partialTicks);
        poseStack.translate(0.0, (double)(-0.25f * scale), 0.0);
        poseStack.mulPose(Axis.YP.rotation(rotation));
        itemRenderer.render(stack, ItemDisplayContext.GROUND, false, poseStack, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY, model);
        poseStack.popPose();
    }

    public static void renderSpiritGlimmer(PoseStack poseStack, SpiritLike spirit, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, spirit, 1.0f, partialTicks);
    }

    public static void renderSpiritGlimmer(PoseStack poseStack, SpiritLike spirit, float scalar, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, SpiritBasedWorldVFXBuilder.create(spirit), spirit.getPrimaryColor(), spirit.getSecondaryColor(), scalar, scalar, partialTicks);
    }

    public static void renderSpiritGlimmer(PoseStack poseStack, SpiritLike spirit, float scaleScalar, float alphaScalar, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, SpiritBasedWorldVFXBuilder.create(spirit), spirit.getPrimaryColor(), spirit.getSecondaryColor(), scaleScalar, alphaScalar, partialTicks);
    }

    public static void renderSpiritGlimmer(PoseStack poseStack, Color primaryColor, Color secondaryColor, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, primaryColor, secondaryColor, 1.0f, partialTicks);
    }

    public static void renderSpiritGlimmer(PoseStack poseStack, Color primaryColor, Color secondaryColor, float scalar, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, VFXBuilders.createWorld(), primaryColor, secondaryColor, scalar, scalar, partialTicks);
    }

    public static void renderSpiritGlimmer(PoseStack poseStack, Color primaryColor, Color secondaryColor, float scaleScalar, float alphaScalar, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, VFXBuilders.createWorld(), primaryColor, secondaryColor, scaleScalar, alphaScalar, partialTicks);
    }

    public static void renderSpiritGlimmer(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, Color primaryColor, Color secondaryColor, float scaleScalar, float alphaScalar, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        LodestoneRenderTypeBuilder star = LodestoneRenderTypes.ADDITIVE_TEXTURE.apply(MalumRenderTypeTokens.STAR);
        LodestoneRenderTypeBuilder twinkle = LodestoneRenderTypes.ADDITIVE_TEXTURE.apply(MalumRenderTypeTokens.TWINKLE);
        float gameTime = (float)level.getGameTime() + partialTicks;
        double sine = Math.abs(Math.sin(gameTime / 80.0f % 360.0f) * (double)0.075f);
        float bounce = EasingHelper.weightedEasingLerp((Easing)Easing.BOUNCE_IN_OUT, (float)(gameTime % 20.0f / 20.0f), (float)0.025f, (float)0.05f, (float)0.025f);
        float scale = (float)(((double)0.12f + sine + (double)bounce) * (double)scaleScalar);
        poseStack.pushPose();
        poseStack.mulPose(minecraft.getEntityRenderDispatcher().cameraOrientation());
        builder.setAlpha(Mth.clamp((float)(0.6f * alphaScalar), (float)0.0f, (float)1.0f)).setColor(primaryColor).setRenderType(star).renderQuad(poseStack, scale * 0.8f);
        builder.setAlpha(Mth.clamp((float)(0.8f * alphaScalar), (float)0.0f, (float)1.0f)).setRenderType(twinkle).renderQuad(poseStack, scale * 0.6f);
        builder.setAlpha(Mth.clamp((float)(0.2f * alphaScalar), (float)0.0f, (float)1.0f)).setColor(secondaryColor).renderQuad(poseStack, scale * 0.6f);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(FloatingItemEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

