/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.scarf;

import com.sammy.malum.config.ClientConfig;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;
import team.lodestar.lodestone.systems.rendering.trail.TrailPoint;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class ScarfRenderHandler {
    public static final WeakHashMap<LivingEntity, List<ScarfRenderData>> SCARF_DATA = new WeakHashMap();

    public static void tickScarfData(ClientTickEvent event) {
        for (Map.Entry<LivingEntity, List<ScarfRenderData>> entry : SCARF_DATA.entrySet()) {
            ArrayList<ScarfRenderData> toRemove = new ArrayList<ScarfRenderData>();
            List<ScarfRenderData> scarfList = entry.getValue();
            for (ScarfRenderData data : scarfList) {
                LivingEntity entity = entry.getKey();
                data.tick(entity);
                if (data.isValid(entity)) continue;
                toRemove.add(data);
            }
            toRemove.forEach(scarfList::remove);
        }
    }

    public static void renderScarfData(RenderLevelStageEvent event) {
        float partialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(true);
        ScarfRenderHandler.renderScarfData(partialTicks);
    }

    public static void renderScarfData(float partialTicks) {
        for (Map.Entry<LivingEntity, List<ScarfRenderData>> entry : SCARF_DATA.entrySet()) {
            List<ScarfRenderData> scarfList = entry.getValue();
            LivingEntity entity = entry.getKey();
            for (ScarfRenderData data : scarfList) {
                data.render(entity, partialTicks);
            }
        }
    }

    public static void addScarfRenderer(LivingEntity living, Consumer<Consumer<ScarfRenderData>> consumer) {
        if (SCARF_DATA.containsKey(living) && SCARF_DATA.get(living).isEmpty()) {
            SCARF_DATA.remove(living);
        }
        if (!SCARF_DATA.containsKey(living)) {
            ArrayList scarfList = new ArrayList();
            Consumer<ScarfRenderData> acceptor = scarfList::add;
            consumer.accept(acceptor);
            SCARF_DATA.put(living, scarfList);
        }
    }

    public static class ScarfRenderData {
        public final RenderTypeToken token;
        public final TrailPointBuilder points;
        public Supplier<Boolean> isValid = () -> true;
        public Color primaryColor = Color.WHITE;
        public Color secondaryColor = Color.WHITE;
        public float horizontalOffset;
        public float scale = 1.0f;
        public float endingScale = 1.0f;
        public float alpha = 1.0f;

        public ScarfRenderData(RenderTypeToken token, int trailLength) {
            this.token = token;
            this.points = new TrailPointBuilder(trailLength);
        }

        public boolean isValid(LivingEntity entity) {
            return entity.isAlive() && !entity.isRemoved() && !entity.isDeadOrDying() && entity.isAddedToLevel() && this.isValid.get() != false;
        }

        public ScarfRenderData setPrimaryColor(Color primaryColor) {
            this.primaryColor = primaryColor;
            return this;
        }

        public ScarfRenderData setSecondaryColor(Color secondaryColor) {
            this.secondaryColor = secondaryColor;
            return this;
        }

        public ScarfRenderData setPredicate(Supplier<Boolean> isValid) {
            this.isValid = isValid;
            return this;
        }

        public ScarfRenderData setHorizontalOffset(float horizontalOffset) {
            this.horizontalOffset = horizontalOffset;
            return this;
        }

        public ScarfRenderData setScale(float scale) {
            this.scale = scale;
            return this;
        }

        public ScarfRenderData setEndingScale(float endingScale) {
            this.endingScale = endingScale;
            return this;
        }

        public ScarfRenderData setAlpha(float alpha) {
            this.alpha = alpha;
            return this;
        }

        public void render(LivingEntity entity, float partialTicks) {
            Minecraft minecraft = Minecraft.getInstance();
            float alpha = this.alpha;
            if (entity.equals((Object)minecraft.cameraEntity) && minecraft.options.getCameraType().isFirstPerson()) {
                alpha *= ((Float)ClientConfig.SCARF_OPACITY.getConfigValue()).floatValue();
            }
            if (alpha <= 0.0f) {
                return;
            }
            BlockPos blockpos = entity.blockPosition().above(2);
            int light = entity.level().hasChunkAt(blockpos) ? LevelRenderer.getLightColor((BlockAndTintGetter)entity.level(), (BlockPos)blockpos) : 0;
            LodestoneRenderTypeBuilder renderType = LodestoneRenderTypes.TEXTURE_FADE.apply(this.token);
            VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType(renderType).setLight(light).setAlpha(alpha);
            Vec3 scarfStart = this.getScarfStart(entity, partialTicks);
            this.points.setOrigin(scarfStart);
            builder.usePartialTicks(0.0f).renderTrail(this.points, f -> Float.valueOf(Mth.lerp((float)f.floatValue(), (float)this.endingScale, (float)this.scale)), f -> builder.setColor(ColorHelper.colorLerp((Easing)Easing.LINEAR, (float)((float)Mth.floor((float)(f.floatValue() * 4.0f)) / 4.0f), (Color)this.secondaryColor, (Color)this.primaryColor)));
        }

        public void tick(LivingEntity entity) {
            Vec3 movement = this.getScarfPointMovement(entity);
            this.points.addTrailPoint(new TrailPoint(this.getScarfStart(entity, 0.5f)));
            this.points.run(t -> t.move(movement));
            List list = this.points.getTrailPoints();
            if (list.size() > 2) {
                float age = this.points.getTrailLength().intValue();
                for (int i = 0; i < list.size() - 1; ++i) {
                    TrailPoint currentPoint = (TrailPoint)list.get(i);
                    TrailPoint nextPoint = (TrailPoint)list.get(i + 1);
                    float delta = Mth.clamp((float)((float)currentPoint.getAge() / age * 4.0f), (float)0.0f, (float)1.0f);
                    Vec3 currentPos = currentPoint.getPosition();
                    Vec3 nextPos = nextPoint.getPosition();
                    float lerpX = (float)Mth.lerp((double)delta, (double)currentPos.x, (double)nextPos.x);
                    float lerpY = (float)Mth.lerp((double)delta, (double)currentPos.y, (double)nextPos.y);
                    float lerpZ = (float)Mth.lerp((double)delta, (double)currentPos.z, (double)nextPos.z);
                    currentPoint.setPosition(new Vec3((double)lerpX, (double)lerpY, (double)lerpZ));
                }
            }
            this.points.tickTrailPoints();
        }

        public Vec3 getScarfPointMovement(LivingEntity entity) {
            Vec3 lookDirection = entity.getForward().scale(Mth.clamp((double)entity.getDeltaMovement().length(), (double)0.0, (double)1.0));
            double y = -0.02f;
            if (lookDirection.length() < (double)0.1f) {
                lookDirection = entity.getForward().scale((double)0.3f);
                y = -0.08f;
            }
            double x = lookDirection.x * (double)-0.1f;
            double z = lookDirection.z * (double)-0.1f;
            return new Vec3(x, y, z);
        }

        public Vec3 getScarfStart(LivingEntity entity, float partialTicks) {
            float xLook = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
            float yLook = Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
            Vec3 lookDirection = Vec3.directionFromRotation((Vec2)new Vec2(xLook, yLook));
            float upwardsOffset = entity.getBbHeight() * 0.8f;
            Vec3 eyePosition = entity.getPosition(partialTicks).add(0.0, (double)upwardsOffset, 0.0);
            float yRot = (float)(Mth.atan2((double)lookDirection.x, (double)lookDirection.z) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 offsetPosition = eyePosition.subtract(lookDirection.scale((double)0.2f).add(left.scale((double)this.horizontalOffset)));
            float angle = ((float)entity.level().getGameTime() + partialTicks) * 0.05f % 6.28f;
            float offsetStrength = 0.01f;
            float xOffset = Mth.sin((float)(angle * 4.0f)) * offsetStrength;
            float yOffset = Mth.sin((float)(angle * 4.0f)) * offsetStrength;
            float zOffset = Mth.cos((float)(angle * 4.0f)) * offsetStrength;
            return offsetPosition.add((double)xOffset, (double)yOffset, (double)zOffset);
        }
    }
}

