/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex;

import com.google.common.collect.ImmutableList;
import com.sammy.malum.client.screen.codex.BookEntryBuilder;
import com.sammy.malum.client.screen.codex.PlacedBookEntry;
import com.sammy.malum.client.screen.codex.WidgetDesignType;
import com.sammy.malum.client.screen.codex.objects.progression.ProgressionEntryObject;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;

public class PlacedBookEntryBuilder
extends BookEntryBuilder {
    public static final int SPACING = 40;
    protected PlacedBookEntry.WidgetSupplier widgetSupplier = ProgressionEntryObject::new;
    @Nullable
    protected Consumer<ProgressionEntryObject> widgetConfig = null;
    @Nullable
    protected Consumer<PlacedBookEntryBuilder> fragmentProperties = null;
    protected boolean isFragment = false;
    protected final int xOffset;
    protected final int yOffset;

    protected PlacedBookEntryBuilder(String identifier, boolean isVoid, int xOffset, int yOffset) {
        super(identifier, isVoid);
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public PlacedBookEntryBuilder(String identifier, int xOffset, int yOffset) {
        super(identifier);
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public PlacedBookEntryBuilder setWidgetSupplier(PlacedBookEntry.WidgetSupplier widgetSupplier) {
        this.widgetSupplier = widgetSupplier;
        return this;
    }

    public PlacedBookEntryBuilder configureWidget(Consumer<ProgressionEntryObject> configure) {
        this.widgetConfig = this.widgetConfig == null ? configure : this.widgetConfig.andThen(configure);
        return this;
    }

    public PlacedBookEntryBuilder withEmptyFragmentEntry(WidgetDesignType designType) {
        this.fragmentProperties = b -> b.configureWidget(widget -> widget.setDesign(designType.createDesign(d -> d.withFilling(WidgetDesignType.FillingType.DARK)))).withTitleStyle(s -> s.withColor(ChatFormatting.GRAY)).withSubtitleStyle(s -> s.withColor(ChatFormatting.DARK_GRAY));
        return this;
    }

    public PlacedBookEntryBuilder withTraceFragmentEntry() {
        this.fragmentProperties = b -> b.configureWidget(widget -> widget.setDesign(WidgetDesignType.EMPTY.createDesign(null, null))).disableTooltip();
        return this;
    }

    public PlacedBookEntryBuilder withFragmentEntry(Consumer<PlacedBookEntryBuilder> properties) {
        this.fragmentProperties = this.fragmentProperties == null ? properties : this.fragmentProperties.andThen(properties);
        return this;
    }

    protected PlacedBookEntryBuilder setFragment() {
        this.isFragment = true;
        return this;
    }

    public boolean hasFragment() {
        return this.fragmentProperties != null;
    }

    public PlacedBookEntry buildFragment() {
        if (this.fragmentProperties == null) {
            return null;
        }
        PlacedBookEntryBuilder fragment = new PlacedBookEntryBuilder("fragment." + this.identifier, this.isVoid, this.xOffset, this.yOffset);
        fragment.setFragment().configureWidget(this.widgetConfig).setWidgetSupplier(this.widgetSupplier).setEntryCondition(() -> !this.condition.getAsBoolean()).withTitleStyle(style -> style.withItalic(Boolean.valueOf(true))).withSubtitleStyle(style -> style.withItalic(Boolean.valueOf(true)));
        this.fragmentProperties.accept(fragment);
        return fragment.build();
    }

    @Override
    public PlacedBookEntry build() {
        ImmutableList bookPages = ImmutableList.copyOf((Collection)this.pages);
        ImmutableList entryReferences = ImmutableList.copyOf((Collection)this.references);
        PlacedBookEntry.BookEntryWidgetPlacementData data = new PlacedBookEntry.BookEntryWidgetPlacementData(this.xOffset * 40, this.yOffset * 40, this.widgetSupplier, this.widgetConfig);
        return new PlacedBookEntry(this.identifier, this.isVoid, data, (ImmutableList<BookPage>)bookPages, (ImmutableList<EntryReference>)entryReferences, this.condition, this.associatedSpirit, this.isFragment, this.titleStyle, this.subtitleStyle, this.hasTooltip);
    }
}

