/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages;

import com.sammy.malum.client.screen.codex.helper.CodexTextHelper;
import com.sammy.malum.client.screen.codex.screens.CodexEntryScreen;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class BookPage {
    public static final String TEXT = "malum.gui.book.entry.page.text";
    public static final String HEADLINE = "malum.gui.book.entry.page.headline";
    public static boolean isVoidThemed = false;
    @Nullable
    protected final ResourceLocation background;

    public static String getRecipeInfoHeadlineKey(String recipeType) {
        return "malum.gui.book.entry.page.info." + recipeType + ".headline";
    }

    public static String getRecipeInfoKey(String recipeType) {
        return "malum.gui.book.entry.page.info." + recipeType;
    }

    public BookPage(@Nullable ResourceLocation background) {
        this.background = background;
    }

    public boolean isValid() {
        return true;
    }

    public void render(CodexEntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
    }

    public void renderLate(CodexEntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
    }

    public void click(CodexEntryScreen screen, int left, int top, double mouseX, double mouseY, double relativeMouseX, double relativeMouseY) {
    }

    public ResourceLocation getBackground(boolean isRightSide) {
        return this.background;
    }

    protected void renderRecipeInfo(GuiGraphics guiGraphics, CodexEntryScreen screen, String recipeName, int left, int top, int mouseX, int mouseY) {
        screen.renderLater(() -> {
            if (screen.isHovering(mouseX, mouseY, left, top, 18, 18)) {
                MutableComponent headline = Component.translatable((String)BookPage.getRecipeInfoHeadlineKey(recipeName)).withStyle(isVoidThemed ? ChatFormatting.DARK_PURPLE : ChatFormatting.GOLD);
                MutableComponent header = Component.literal((String)"\u2507 ").withStyle(ChatFormatting.DARK_GRAY);
                MutableComponent info = Component.translatable((String)BookPage.getRecipeInfoKey(recipeName)).withStyle(ChatFormatting.GRAY);
                List<Component> wrapped = CodexTextHelper.wrapComponent((Component)info, header, 300);
                List<MutableComponent> tooltip = Stream.concat(Stream.of(headline), wrapped.stream()).toList();
                guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, tooltip, mouseX, mouseY);
            }
        });
    }
}

