/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.text;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.helper.CodexRenderHelper;
import com.sammy.malum.client.screen.codex.helper.CodexTextHelper;
import com.sammy.malum.client.screen.codex.pages.text.HeadlineTextPage;
import com.sammy.malum.client.screen.codex.screens.CodexEntryScreen;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class HeadlineTextIconPage
extends HeadlineTextPage {
    private static final ResourceLocation GLOW_TEXTURE = MalumMod.malumPath("textures/gui/book/icon_glow.png");
    private static final ResourceLocation ANCHOR_TEXTURE = MalumMod.malumPath("textures/vfx/rite_anchor_glow_pointer.png");
    private final ResourceLocation icon;
    private final SpiritLike spirit;

    public static HeadlineTextIconPage riteAnchorPage(String text, SpiritLike spirit) {
        return new HeadlineTextIconPage(text, ANCHOR_TEXTURE, spirit);
    }

    public HeadlineTextIconPage(String headline, String text, ResourceLocation icon, SpiritLike spirit) {
        super(MalumMod.malumPath("textures/gui/book/pages/headline_icon_page.png"), headline, text);
        this.icon = icon;
        this.spirit = spirit;
    }

    public HeadlineTextIconPage(String text, ResourceLocation icon, SpiritLike spirit) {
        this(text, text + ".1", icon, spirit);
    }

    @Override
    public void render(CodexEntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        int iconX = left + 63;
        int iconY = top + 38;
        CodexTextHelper.renderHeadline(guiGraphics, this.headline, left, top);
        CodexTextHelper.renderWrappingText(guiGraphics, this.text, (float)(left + 6), (float)(top + 75), 130);
        CodexRenderHelper.renderSpiritIcon(this.icon, guiGraphics.pose(), this.spirit, false, iconX, iconY);
        CodexRenderHelper.renderSpiritIcon(GLOW_TEXTURE, guiGraphics.pose(), this.spirit, false, iconX - 8, iconY - 8, 32, 32);
        if (screen.isHovering(mouseX, mouseY, iconX, iconY, 16, 16)) {
            Minecraft minecraft = Minecraft.getInstance();
            guiGraphics.renderComponentTooltip(minecraft.font, Screen.getTooltipFromItem((Minecraft)minecraft, (ItemStack)this.spirit.getSpiritStack()), mouseX, mouseY);
        }
    }
}

