/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.blight;

import com.sammy.malum.registry.common.MalumTags;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CreepingBlightBlock
extends Block {
    protected static final VoxelShape SHAPE_GROUNDED_ROOTS_X = Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0);
    protected static final VoxelShape SHAPE_GROUNDED_ROOTS_Z = Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_ROOTED_EAST = Block.box((double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0);
    protected static final VoxelShape SHAPE_ROOTED_WEST = Block.box((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)12.0, (double)14.0);
    protected static final VoxelShape SHAPE_ROOTED_SOUTH = Block.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_ROOTED_NORTH = Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)12.0, (double)12.0);
    protected static final VoxelShape SHAPE_BRACED_EAST = Block.box((double)4.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_BRACED_WEST = Block.box((double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_BRACED_SOUTH = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_BRACED_NORTH = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SHAPE_HANGING_EAST = Block.box((double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_HANGING_WEST = Block.box((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_HANGING_SOUTH = Block.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_HANGING_NORTH = Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)12.0);
    public static final EnumProperty<BlightType> BLIGHT_TYPE = EnumProperty.create((String)"blight_type", BlightType.class);

    public CreepingBlightBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(BLIGHT_TYPE, (Comparable)((Object)BlightType.CLINGING_BLIGHT)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        builder.add(new Property[]{BLIGHT_TYPE});
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)(direction.getAxis().isHorizontal() ? direction.getOpposite() : context.getHorizontalDirection()));
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        if (!direction.getAxis().isVertical()) {
            state = (BlockState)state.setValue(BLIGHT_TYPE, (Comparable)((Object)BlightType.SOULWOOD_SPIKE));
        } else {
            if (direction.equals((Object)Direction.DOWN)) {
                state = (BlockState)state.setValue(BLIGHT_TYPE, (Comparable)((Object)BlightType.HANGING_BLIGHT));
            }
            if ((direction.getAxis().isHorizontal() || direction.equals((Object)Direction.UP)) && !(state = (BlockState)state.setValue(BLIGHT_TYPE, (Comparable)((Object)BlightType.CLINGING_BLIGHT))).canSurvive((LevelReader)level, clickedPos)) {
                return (BlockState)state.setValue(BLIGHT_TYPE, (Comparable)((Object)BlightType.SOULWOOD_ROOTS));
            }
        }
        return state.canSurvive((LevelReader)level, clickedPos) ? state : null;
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlightType value = (BlightType)((Object)pState.getValue(BLIGHT_TYPE));
        Direction direction = (Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (value.equals((Object)BlightType.CLINGING_BLIGHT) || value.equals((Object)BlightType.SOULWOOD_ROOTS)) {
            BlockPos below = pPos.below();
            if (!pLevel.getBlockState(below).is(MalumTags.BlockTags.BLIGHT_PLACEABLE_ON)) {
                return false;
            }
            if (!Block.canSupportCenter((LevelReader)pLevel, (BlockPos)below, (Direction)Direction.UP)) {
                return false;
            }
            if (value.equals((Object)BlightType.CLINGING_BLIGHT) && !Block.canSupportCenter((LevelReader)pLevel, (BlockPos)pPos.relative(direction), (Direction)direction.getOpposite())) {
                return false;
            }
        }
        if (value.equals((Object)BlightType.HANGING_BLIGHT) && !Block.canSupportCenter((LevelReader)pLevel, (BlockPos)pPos.above(), (Direction)Direction.DOWN)) {
            return false;
        }
        if (value.equals((Object)BlightType.SOULWOOD_ROOTS)) {
            return true;
        }
        BlockPos pos = pPos.relative(direction);
        return Block.canSupportCenter((LevelReader)pLevel, (BlockPos)pos, (Direction)direction);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape[] shapeArray = switch (((BlightType)((Object)pState.getValue(BLIGHT_TYPE))).ordinal()) {
            case 0 -> new VoxelShape[]{SHAPE_GROUNDED_ROOTS_X, SHAPE_GROUNDED_ROOTS_X, SHAPE_GROUNDED_ROOTS_Z, SHAPE_GROUNDED_ROOTS_Z};
            case 2 -> new VoxelShape[]{SHAPE_ROOTED_EAST, SHAPE_ROOTED_WEST, SHAPE_ROOTED_SOUTH, SHAPE_ROOTED_NORTH};
            case 1 -> new VoxelShape[]{SHAPE_BRACED_EAST, SHAPE_BRACED_WEST, SHAPE_BRACED_SOUTH, SHAPE_BRACED_NORTH};
            case 3 -> new VoxelShape[]{SHAPE_HANGING_EAST, SHAPE_HANGING_WEST, SHAPE_HANGING_SOUTH, SHAPE_HANGING_NORTH};
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(pState.getValue(BLIGHT_TYPE)));
        };
        switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case EAST: {
                return shapeArray[0];
            }
            case WEST: {
                return shapeArray[1];
            }
            case SOUTH: {
                return shapeArray[2];
            }
            case NORTH: {
                return shapeArray[3];
            }
        }
        return super.getShape(pState, pLevel, pPos, pContext);
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.empty();
    }

    public static enum BlightType implements StringRepresentable
    {
        SOULWOOD_ROOTS,
        SOULWOOD_SPIKE,
        CLINGING_BLIGHT,
        HANGING_BLIGHT;

        final String name = this.name().toLowerCase(Locale.ROOT);

        public String getSerializedName() {
            return this.name;
        }
    }
}

