/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.redstone;

import com.sammy.malum.common.block.curiosities.redstone.SpiritDiodeBlockEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.systems.block.LodestoneEntityBlock;

public abstract class SpiritDiodeBlock<T extends SpiritDiodeBlockEntity>
extends LodestoneEntityBlock<T> {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;

    public SpiritDiodeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public abstract boolean processUpdate(Level var1, BlockPos var2, BlockState var3, T var4, int var5, int var6);

    public abstract boolean shouldUpdateWhenNeighborChanged(Level var1, BlockPos var2, BlockState var3, T var4, int var5);

    public int redstoneTicksUntilUpdate(Level level, BlockPos pos, BlockState state, T diode, int cachedSignal, int liveSignal) {
        return Math.max(((SpiritDiodeBlockEntity)((Object)diode)).getAdjustedFrequency(), 1);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        Direction direction;
        int liveSignal;
        SpiritDiodeBlockEntity spiritDiode;
        BlockEntity blockEntity;
        if (!level.getBlockTicks().willTickThisTick(pos, (Object)this) && (blockEntity = level.getBlockEntity(pos)) instanceof SpiritDiodeBlockEntity && this.shouldUpdateWhenNeighborChanged(level, pos, state, spiritDiode = (SpiritDiodeBlockEntity)blockEntity, liveSignal = level.getSignal(pos.relative(direction = (Direction)state.getValue((Property)FACING)), direction))) {
            if (spiritDiode.cachedInputSignal == -1) {
                spiritDiode.cachedInputSignal = liveSignal;
            }
            int delay = this.redstoneTicksUntilUpdate(level, pos, state, spiritDiode, liveSignal, liveSignal);
            level.scheduleTick(pos, (Block)this, delay);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                spiritDiode.updateAnimation(serverLevel, pos, liveSignal);
            }
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SpiritDiodeBlockEntity) {
            int liveSignal;
            SpiritDiodeBlockEntity spiritDiode = (SpiritDiodeBlockEntity)blockEntity;
            Direction direction = (Direction)state.getValue((Property)FACING);
            int cachedSignal = spiritDiode.cachedInputSignal;
            if (cachedSignal == -1) {
                cachedSignal = 0;
            }
            if (this.processUpdate((Level)level, pos, state, spiritDiode, cachedSignal, liveSignal = level.getSignal(pos.relative(direction), direction))) {
                int delay = this.redstoneTicksUntilUpdate((Level)level, pos, state, spiritDiode, cachedSignal, liveSignal);
                level.scheduleTick(pos, (Block)this, delay);
                spiritDiode.updateAnimation(level, pos, cachedSignal);
            }
            spiritDiode.cachedInputSignal = -1;
        }
    }

    public void updateState(Level level, BlockPos pos, BlockState state, T diode) {
        boolean isPowered;
        boolean shouldBePowered = ((SpiritDiodeBlockEntity)((Object)diode)).getOutputSignal() != 0;
        if (shouldBePowered != (isPowered = ((Boolean)state.getValue((Property)POWERED)).booleanValue())) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(shouldBePowered)), 2);
        }
        this.notifyNeighborsInFront(level, pos, state);
    }

    public void notifyNeighborsInFront(Level level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (!EventHooks.onNeighborNotify((Level)level, (BlockPos)pos, (BlockState)level.getBlockState(pos), EnumSet.of(direction.getOpposite()), (boolean)false).isCanceled()) {
            BlockPos blockpos = pos.relative(direction.getOpposite());
            level.neighborChanged(blockpos, (Block)this, pos);
            level.updateNeighborsAtExceptFromFacing(blockpos, (Block)this, direction);
        }
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return facing == direction || facing.getOpposite() == direction;
    }

    protected int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        BlockEntity blockentity;
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && state.getValue((Property)FACING) == side && (blockentity = level.getBlockEntity(pos)) instanceof SpiritDiodeBlockEntity) {
            SpiritDiodeBlockEntity spiritDiode = (SpiritDiodeBlockEntity)blockentity;
            return spiritDiode.getOutputSignal();
        }
        return 0;
    }

    public boolean getWeakChanges(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction direction = pContext.getHorizontalDirection();
        if (pContext.getPlayer() == null || !pContext.getPlayer().isCrouching()) {
            direction = direction.getOpposite();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, OPEN, FACING});
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

