/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.redstone.wavebanker;

import com.sammy.malum.common.block.curiosities.redstone.SpiritDiodeBlock;
import com.sammy.malum.common.block.curiosities.redstone.wavebanker.WaveBankerBlockEntity;
import com.sammy.malum.registry.common.MalumSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class WaveBankerBlock
extends SpiritDiodeBlock<WaveBankerBlockEntity> {
    public WaveBankerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public boolean processUpdate(Level level, BlockPos pos, BlockState state, WaveBankerBlockEntity diode, int cachedSignal, int liveSignal) {
        int previousSignal = diode.outputSignal;
        diode.outputSignal = cachedSignal;
        SoundEvent sound = previousSignal > diode.outputSignal ? (SoundEvent)MalumSoundEvents.WAVEBANKER_RELEASE.get() : (SoundEvent)MalumSoundEvents.WAVEBANKER_STORE.get();
        level.playSound(null, pos, sound, SoundSource.BLOCKS);
        this.updateState(level, pos, state, diode);
        return diode.outputSignal > 0 && liveSignal == 0;
    }

    @Override
    public boolean shouldUpdateWhenNeighborChanged(Level level, BlockPos pos, BlockState state, WaveBankerBlockEntity diode, int liveSignal) {
        return liveSignal != diode.outputSignal;
    }

    @Override
    public int redstoneTicksUntilUpdate(Level level, BlockPos pos, BlockState state, WaveBankerBlockEntity diode, int cachedSignal, int liveSignal) {
        if (liveSignal >= diode.outputSignal) {
            return 4;
        }
        return super.redstoneTicksUntilUpdate(level, pos, state, diode, cachedSignal, liveSignal);
    }
}

