/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.runic_workbench;

import com.sammy.malum.common.block.storage.MalumItemHolderBlockEntity;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.RuneworkingRecipe;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import com.sammy.malum.visual_effects.networked.runic_workbench.RunicWorkbenchEffectData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectType;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

public class RunicWorkbenchBlockEntity
extends MalumItemHolderBlockEntity {
    public static final Vec3 RUNIC_WORKBENCH_ITEM_OFFSET = new Vec3(0.5, 1.25, 0.5);
    protected int progress = 0;
    protected RuneworkingRecipe.RunicWorkbenchRecipeInput input;

    public RunicWorkbenchBlockEntity(BlockEntityType<? extends RunicWorkbenchBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public RunicWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends RunicWorkbenchBlockEntity>)((BlockEntityType)MalumBlockEntities.RUNIC_WORKBENCH.get()), pos, state);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("progress", this.progress);
        if (this.input != null) {
            RegistryAccess access = this.level.registryAccess();
            pTag.put("primaryInput", this.input.primaryInput().save((HolderLookup.Provider)access));
            pTag.put("secondaryInput", this.input.secondaryInput().save((HolderLookup.Provider)access));
        }
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.progress = pTag.getInt("progress");
        if (pTag.contains("primaryInput") && pTag.contains("secondaryInput")) {
            ItemStack primaryInput = ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)pTag.getCompound("primaryInput"));
            ItemStack secondaryInput = ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)pTag.getCompound("secondaryInput"));
            this.input = new RuneworkingRecipe.RunicWorkbenchRecipeInput(primaryInput, secondaryInput);
        }
    }

    @Override
    public Vec3 getItemOffset(float partialTicks) {
        if (this.inventory.getStackInSlot(0).getItem() instanceof SpiritShardItem) {
            float gameTime = (float)this.level.getGameTime() + partialTicks;
            return RUNIC_WORKBENCH_ITEM_OFFSET.add(0.0, (double)((float)Math.sin(gameTime % 360.0f / 20.0f) * 0.05f), 0.0);
        }
        return RUNIC_WORKBENCH_ITEM_OFFSET;
    }

    public ItemInteractionResult onUseWithItem(Player player, ItemStack heldStack, InteractionHand hand) {
        ItemStack inventoryStack = this.inventory.getStackInSlot(0);
        if (inventoryStack.isEmpty()) {
            return super.onUseWithItem(player, heldStack, hand);
        }
        boolean success = this.tryCraft(this.level, inventoryStack, heldStack, !player.isCreative());
        if (success) {
            return ItemInteractionResult.SUCCESS;
        }
        return super.onUseWithItem(player, heldStack, hand);
    }

    @Override
    public void tick() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.input != null) {
                ++this.progress;
                if (this.progress == 20) {
                    this.craft(serverLevel);
                    this.progress = 0;
                    this.input = null;
                }
            }
        }
        super.tick();
    }

    public boolean tryCraft(Level level, ItemStack primaryInput, ItemStack secondaryInput, boolean consumeItems) {
        RuneworkingRecipe recipe = (RuneworkingRecipe)LodestoneRecipeType.getRecipe((Level)level, (RecipeType)((RecipeType)MalumRecipeTypes.RUNEWORKING.get()), (RecipeInput)new RuneworkingRecipe.RunicWorkbenchRecipeInput(primaryInput, secondaryInput));
        if (recipe == null) {
            return false;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int primaryCount = recipe.input.count();
            int secondaryCount = recipe.secondaryInput.count();
            this.input = new RuneworkingRecipe.RunicWorkbenchRecipeInput(primaryInput.copyWithCount(primaryCount), secondaryInput.copyWithCount(secondaryCount));
            if (consumeItems) {
                primaryInput.shrink(primaryCount);
                secondaryInput.shrink(secondaryCount);
            }
            SpiritShardItem spirit = null;
            Item item = this.input.secondaryInput().getItem();
            if (item instanceof SpiritShardItem) {
                SpiritShardItem shardItem;
                spirit = shardItem = (SpiritShardItem)item;
            } else {
                item = this.input.primaryInput().getItem();
                if (item instanceof SpiritShardItem) {
                    SpiritShardItem shardItem;
                    spirit = shardItem = (SpiritShardItem)item;
                }
            }
            serverLevel.playSound(null, this.worldPosition, recipe.soundType, SoundSource.BLOCKS, 1.0f, RandomHelper.randomBetween((RandomSource)serverLevel.random, (float)0.9f, (float)1.2f));
            MalumNetworkedParticleEffectType effectType = spirit != null ? MalumParticleEffectTypes.RUNIC_WORKBENCH_CRAFTS_RUNE : MalumParticleEffectTypes.RUNIC_WORKBENCH_CRAFTS_SPIRITLESS_ITEM;
            NetworkedParticleEffectType.ParticleEffectBuilder particle = effectType.createEffect(this.worldPosition).customData(new RunicWorkbenchEffectData(this.input.primaryInput().copy(), this.input.secondaryInput().copy()));
            if (spirit != null) {
                particle.color(spirit);
            }
            particle.spawn(serverLevel);
        }
        return true;
    }

    public void craft(ServerLevel level) {
        RuneworkingRecipe recipe = (RuneworkingRecipe)LodestoneRecipeType.getRecipe((Level)level, (RecipeType)((RecipeType)MalumRecipeTypes.RUNEWORKING.get()), (RecipeInput)this.input);
        if (recipe == null) {
            return;
        }
        Vec3 itemPos = this.getItemPos();
        ItemEntity itemEntity = new ItemEntity((Level)level, itemPos.x, itemPos.y, itemPos.z, recipe.output.copy());
        itemEntity.setPickUpDelay(15);
        itemEntity.setDeltaMovement(0.0, 0.25, 0.0);
        level.addFreshEntity((Entity)itemEntity);
        this.setDirty();
    }
}

