/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.weeping_well;

import com.sammy.malum.common.block.curiosities.weeping_well.PrimordialSoupBlock;
import com.sammy.malum.common.block.curiosities.weeping_well.VoidConduitBlockEntity;
import com.sammy.malum.core.handlers.WeepingWellRejectionHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.lodestar.lodestone.systems.block.LodestoneEntityBlock;

public class VoidConduitBlock<T extends VoidConduitBlockEntity>
extends LodestoneEntityBlock<T> {
    public VoidConduitBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return PrimordialSoupBlock.TOP_SHAPE;
    }

    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.empty();
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        EntityCollisionContext entityCollisionContext;
        Entity entity;
        if (pContext instanceof EntityCollisionContext && (entity = (entityCollisionContext = (EntityCollisionContext)pContext).getEntity()) != null) {
            return Shapes.empty();
        }
        return this.getShape(pState, pLevel, pPos, pContext);
    }

    public boolean skipRendering(BlockState pState, BlockState pAdjacentBlockState, Direction pDirection) {
        return pAdjacentBlockState.getBlock() instanceof PrimordialSoupBlock || super.skipRendering(pState, pAdjacentBlockState, pDirection);
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        WeepingWellRejectionHandler.handlePrimordialSoupContact(pEntity);
    }

    public boolean canBeReplaced(BlockState pState, Fluid pFluid) {
        return false;
    }
}

