/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.ether;

import com.mojang.serialization.DynamicOps;
import com.sammy.malum.common.block.ether.EtherBrazierBlock;
import com.sammy.malum.common.block.ether.EtherTorchBlock;
import com.sammy.malum.common.block.ether.EtherWallTorchBlock;
import com.sammy.malum.common.item.ether.EtherItem;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.awt.Color;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;

public class EtherBlockEntity
extends LodestoneBlockEntity {
    public DyedItemColor firstColor = EtherItem.DEFAULT_FIRST_COLOR;
    public DyedItemColor secondColor = EtherItem.DEFAULT_SECOND_COLOR;

    public EtherBlockEntity(BlockEntityType<? extends EtherBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public EtherBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends EtherBlockEntity>)((BlockEntityType)MalumBlockEntities.ETHER.get()), pos, state);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.DYED_COLOR, (Object)this.firstColor);
        components.set(MalumDataComponents.SECONDARY_DYED_COLOR, (Object)this.secondColor);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.firstColor = (DyedItemColor)componentInput.getOrDefault(DataComponents.DYED_COLOR, (Object)this.firstColor);
        this.secondColor = (DyedItemColor)componentInput.getOrDefault(MalumDataComponents.SECONDARY_DYED_COLOR, (Object)this.secondColor);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("firstColor");
        tag.remove("secondColor");
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.firstColor = DyedItemColor.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("firstColor")).result().orElse(EtherItem.DEFAULT_FIRST_COLOR);
        if (!EtherItem.isIridescent(this)) {
            this.secondColor = this.firstColor;
            return;
        }
        this.secondColor = DyedItemColor.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("secondColor")).result().orElse(EtherItem.DEFAULT_SECOND_COLOR);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.firstColor != null) {
            tag.put("firstColor", (Tag)DyedItemColor.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.firstColor).getOrThrow());
        }
        if (EtherItem.isIridescent(this) && this.secondColor != null) {
            tag.put("secondColor", (Tag)DyedItemColor.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.secondColor).getOrThrow());
        }
        super.saveAdditional(tag, registries);
    }

    public void clientTick(Level level) {
        ParticleEffectSpawner lightSpecs;
        float scale;
        if (this.firstColor == null) {
            return;
        }
        RandomSource random = level.random;
        Color start = new Color(this.firstColor.rgb());
        Color end = new Color(this.secondColor == null ? this.firstColor.rgb() : this.secondColor.rgb());
        double x = (float)this.worldPosition.getX() + 0.5f;
        double y = (float)this.worldPosition.getY() + 0.5f;
        double z = (float)this.worldPosition.getZ() + 0.5f;
        Block block = this.getBlockState().getBlock();
        Objects.requireNonNull(block);
        Block block2 = block;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EtherWallTorchBlock.class, EtherTorchBlock.class, EtherBrazierBlock.class}, (Object)block2, n)) {
            case 0: {
                EtherWallTorchBlock etherWallTorchBlock = (EtherWallTorchBlock)block2;
                float offset = 0.15f;
                Direction direction = (Direction)this.getBlockState().getValue((Property)WallTorchBlock.FACING);
                x -= (double)((float)direction.getNormal().getX() * offset);
                y += (double)0.4f;
                z -= (double)((float)direction.getNormal().getZ() * offset);
                break;
            }
            case 1: {
                EtherTorchBlock etherTorchBlock = (EtherTorchBlock)block2;
                y += (double)0.3f;
                break;
            }
            case 2: {
                EtherBrazierBlock etherBrazierBlock = (EtherBrazierBlock)block2;
                y -= (double)0.05f;
                break;
            }
        }
        Vec3 sparkPos = new Vec3(x, y - (double)0.05f, z);
        if (level.getGameTime() % 2L == 0L) {
            ColorParticleData color = ColorParticleData.create((Color)start, (Color)end).setCoefficient(1.5f).setEasing(Easing.SINE_IN_OUT).build();
            int lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)50, (int)60);
            scale = RandomHelper.randomBetween((RandomSource)random, (float)0.7f, (float)0.9f);
            float velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.02f, (float)0.025f);
            lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, sparkPos, color);
            lightSpecs.getBuilder().setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setLifetime(lifeTime).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.2f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN_OUT).build()).addMotion(0.0, (double)(velocity * 1.2f), 0.0);
            lightSpecs.spawnParticlesRaw();
        }
        if (level.getGameTime() % 4L == 0L) {
            ColorParticleData color = ColorParticleData.create((Color)start, (Color)end).setCoefficient(2.5f).setEasing(Easing.SINE_IN_OUT).build();
            int lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)50, (int)60);
            scale = RandomHelper.randomBetween((RandomSource)random, (float)0.3f, (float)0.5f);
            float velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.02f, (float)0.025f);
            lightSpecs = SparkParticleEffects.spiritMotionSparks(level, sparkPos, color);
            lightSpecs.getBuilder().setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setLifetime(lifeTime).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.6f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN_OUT).build()).addMotion(0.0, (double)(velocity * 1.4f), 0.0).setRandomOffset((double)0.1f);
            lightSpecs.spawnParticlesRaw();
        }
        if (level.getGameTime() % 16L == 0L) {
            ColorParticleData color = ColorParticleData.create((Color)start, (Color)end).setCoefficient(0.6f).setEasing(Easing.SINE_IN_OUT).build();
            int lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)50, (int)60);
            scale = RandomHelper.randomBetween((RandomSource)random, (float)0.9f, (float)1.2f);
            WorldParticleBuilder.create(MalumParticles.GIANT_GLOWING_STAR).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)0.2f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN).build()).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setLifetime(lifeTime).setColorData((ColorParticleDataWrapper)color).enableNoClip().spawn(level, x, y, z);
        }
        if (level.getGameTime() % 4L == 0L) {
            ColorParticleData color = ColorParticleData.create((Color)start, (Color)end).setCoefficient(0.6f).setEasing(Easing.SINE_IN_OUT).build();
            int lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)20, (int)30);
            scale = RandomHelper.randomBetween((RandomSource)random, (float)0.25f, (float)0.35f);
            WorldParticleBuilder.create(MalumParticles.STAR).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)0.6f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN).build()).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setLifetime(lifeTime).setColorData((ColorParticleDataWrapper)color).enableNoClip().spawn(level, x, y, z);
        }
    }
}

