/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.scythe;

import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.item.MalumItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;

public abstract class AbstractScytheProjectileEntity
extends ThrowableItemProjectile {
    public float spinOffset;
    public int slot;
    public int age;
    public float damage;
    public float magicDamage;
    public int enemiesHit;
    public int returnTimer;

    public AbstractScytheProjectileEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.spinOffset = (float)((double)this.random.nextFloat() * Math.PI * 2.0);
        this.noPhysics = true;
    }

    public AbstractScytheProjectileEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
        this.spinOffset = (float)((double)this.random.nextFloat() * Math.PI * 2.0);
        this.noPhysics = true;
    }

    public void setData(Entity owner, float damage, float magicDamage, int slot, int returnTimer) {
        this.setOwner(owner);
        this.damage = damage;
        this.magicDamage = magicDamage;
        this.slot = slot;
        this.returnTimer = returnTimer;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.slot != 0) {
            compound.putInt("slot", this.slot);
        }
        if (this.age != 0) {
            compound.putInt("age", this.age);
        }
        if (this.damage != 0.0f) {
            compound.putFloat("damage", this.damage);
        }
        if (this.magicDamage != 0.0f) {
            compound.putFloat("magicDamage", this.magicDamage);
        }
        if (this.enemiesHit != 0) {
            compound.putInt("enemiesHit", this.enemiesHit);
        }
        if (this.returnTimer != 0) {
            compound.putInt("returnTimer", this.returnTimer);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.slot = compound.getInt("slot");
        this.age = compound.getInt("age");
        this.damage = compound.getFloat("damage");
        this.magicDamage = compound.getFloat("magicDamage");
        this.enemiesHit = compound.getInt("enemiesHit");
        this.returnTimer = compound.getInt("returnTimer");
    }

    protected boolean canHitEntity(Entity pTarget) {
        return !pTarget.equals((Object)this.getOwner()) && super.canHitEntity(pTarget);
    }

    protected void onHitEntity(EntityHitResult result) {
        if (this.level().isClientSide()) {
            return;
        }
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            Entity target = result.getEntity();
            DamageSource source = DamageTypeHelper.create((Level)this.level(), MalumDamageTypes.SCYTHE_REBOUND, (Entity)this, (Entity)owner);
            ItemStack heldItem = owner.getMainHandItem();
            owner.setItemInHand(InteractionHand.MAIN_HAND, this.getItem());
            target.invulnerableTime = 0;
            boolean success = target.hurt(source, this.damage);
            if (success && target instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)target;
                if (this.magicDamage > 0.0f && !livingentity.isDeadOrDying()) {
                    livingentity.invulnerableTime = 0;
                    livingentity.hurt(DamageTypeHelper.create((Level)this.level(), MalumDamageTypes.VOODOO, (Entity)this, (Entity)owner), this.magicDamage);
                }
                ++this.enemiesHit;
                this.returnTimer += 2;
            }
            owner.setItemInHand(InteractionHand.MAIN_HAND, heldItem);
            SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)MalumSoundEvents.SCYTHE_SWEEP.get()), (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)this.level().getRandom(), (float)0.75f, (float)1.25f));
        }
        super.onHitEntity(result);
    }

    public void tick() {
        super.tick();
        ++this.age;
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            Vec3 motion = this.getDeltaMovement();
            this.setYRot((float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
    }

    public void shootFromRotation(Entity shooter, float rotationPitch, float rotationYaw, float pitchOffset, float velocity, float innacuracy) {
        float f = -Mth.sin((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitch * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((rotationPitch + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitch * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, innacuracy);
        Vec3 vec3 = shooter.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(vec3.x, 0.0, vec3.z));
    }

    protected Item getDefaultItem() {
        return (Item)MalumItems.CRUDE_SCYTHE.get();
    }

    public boolean isNoGravity() {
        return true;
    }

    public float getPickRadius() {
        return 4.0f;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }
}

