/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.infernal;

import com.sammy.malum.common.data.attachment.AvariceMarkData;
import com.sammy.malum.common.item.WindNucleusItem;
import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;

public class BlastweaverGeas
extends GeasEffect {
    public BlastweaverGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_BLASTWEAVER.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("vastly_bigger_explosions", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("explosion_lover", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("avarice_explosions", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("avarice_vulnerability", new Object[0]));
    }

    public void incomingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        MobEffectInstance effect;
        if (event.getSource().is(DamageTypeTags.IS_EXPLOSION) && (effect = attacker.getEffect(MalumMobEffects.AVARICE)) != null) {
            float modifier = 1.0f + (float)(effect.getAmplifier() + 1) * 0.2f;
            event.setNewDamage(event.getNewDamage() * modifier);
        }
    }

    public static void processExplosion(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        Vec3 center = explosion.center();
        float radius = explosion.radius() * 20.0f;
        List<Entity> explosionAffectedEntities = WindNucleusItem.getExplosionAffectedEntities(event.getLevel(), null, center, radius);
        for (Entity entity : explosionAffectedEntities) {
            Player player;
            if (!(entity instanceof Player) || !GeasEffectHandler.hasGeasEffect((LivingEntity)(player = (Player)entity), MalumGeasEffectTypes.PACT_OF_THE_BLASTWEAVER)) continue;
            AvariceMarkData.applyAvarice((LivingEntity)player, 2);
        }
    }

    public static float increaseExplosionRadius(LivingEntity source, float original) {
        if (source != null && GeasEffectHandler.hasGeasEffect(source, MalumGeasEffectTypes.PACT_OF_THE_BLASTWEAVER)) {
            float bonus = 2.0f;
            MobEffectInstance effect = source.getEffect(MalumMobEffects.AVARICE);
            if (effect != null) {
                bonus += (float)(effect.getAmplifier() + 1) * 0.1f;
            }
            return original + bonus;
        }
        return original;
    }
}

